/** @format */

import { CARD_PRIZE_STATUS } from '../../constants'

export function setCardPrizeStatus(joinedTimes: number, needTimes: number, joinedTimesAwardList: IAwards[]) {
  if (joinedTimes < needTimes) return CARD_PRIZE_STATUS.LOCK

  if (needTimes >= joinedTimes && !joinedTimesAwardList.some(v => v.needTimes === needTimes))
    return CARD_PRIZE_STATUS.UN_LOCK

  if (needTimes >= joinedTimes && joinedTimesAwardList.some(v => v.needTimes === needTimes))
    return CARD_PRIZE_STATUS.SUCCESS
}
