/** @format */
import { getToday } from '../getToday'

// login接口使用 当天第一次登陆有数据变更的时候使用
// updateFirstLoginToday({ $inc: { gameTime: 3}})
export default function updateUserInfo(update?: IPreUpdateQuery) {
  return async function (
    context: IContext<IParams>,
    { userInfo }: IControllerInfos
  ): Promise<IPreUpdateQuery | undefined> {
    if (!userInfo) return {}
    return update
  }
}

export function reduceGameTimes(gameTimes: number) {
  return updateUserInfo({
    $where: `this.gameTimes >= ${gameTimes}`,
    $inc: { gameTimes: -gameTimes }
  })
}
