/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'

export default async function checkPrizeExpired(context: IContext<IParams>, { activityInfo }: IControllerInfos) {
  // 若有过期时间，且已过期
  let { awardReceiveExpiredTime } = activityInfo
  if (awardReceiveExpiredTime && Date.now() > awardReceiveExpiredTime) {
    return resultsModel.error(CODE_TYPES.ERROR_PRIZE_EXPIRED)
  }
}
