/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { isBoolean } from 'lodash'

export default async function checkInviteUserCard(
  context: IContext<{ type: number; activityId: string; inviteId: string }>,
  {}: IControllerInfos,
  [],
  { inviteUserInfo }: IPreCheckData
): Promise<IPreCheckResult> {
  const { type } = context.data

  if (!inviteUserInfo) {
    console.error(`checkInviteUserCard必须搭配 checkInviteId使用`)
  }

  const { cardInfo } = inviteUserInfo

  if (!cardInfo?.type) return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '邀请者该卡片不足')
}
