/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { dbFindOne } from '../../common/mongodb'
import { USER_DB_NAME } from '../../../db'

export default async function checkInviteId(context: IContext<{ activityId: string; inviteId: string }>) {
  const {
    openId,
    data: { activityId, inviteId }
  } = context

  // 自己邀请自己
  if (openId === inviteId) return resultsModel.error(CODE_TYPES.ERROR_NO_INVITE_SELF)

  // 获取邀请者信息
  const inviteUserInfo = await dbFindOne<IUserInfo>(context, USER_DB_NAME, {
    activityId,
    openId: inviteId
  })

  // inviteId的用户信息查询不到, 则inviteId无效
  if (!inviteUserInfo) return resultsModel.error(CODE_TYPES.ERROR_INVALID_INVITE_ID)

  return {
    inviteUserInfo
  }
}
