/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { dbCount } from '../../common/mongodb'
import { STAT_DB_NAME } from '../../../db'
import { STAT_TYPE } from '../../../constants'

export default async function checkHelpRecord(context: IContext<{ activityId: string; inviteId: string }>) {
  const {
    openId,
    data: { activityId, inviteId }
  } = context
  // 邀请成功有该用户信息
  const userInviteSuccessCount = await dbCount(context, STAT_DB_NAME, {
    activityId,
    openId,
    type: STAT_TYPE.INITE_SUCCESS
  })
  if (userInviteSuccessCount) return resultsModel.error(CODE_TYPES.ERROR_AREADY_INVITE_SUCCESS)

  return { userInviteSuccessCount }
}
