/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { isBoolean } from 'lodash'

export default async function checkFollow(context: IContext<IParams>): Promise<IPreCheckResult> {
  const { isFollow } = context.data

  if (!isBoolean(isFollow)) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '缺少isFollow参数')
  if (!isFollow) {
    return resultsModel.error(CODE_TYPES.ERROR_NO_FOLLOW)
  }
}
