"use strict";
/** @format */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var utils_1 = require("../utils");
var service_1 = require("../service");
// {
//   "handler": "getTaskList",
//   "data": {
//     "activityId": "5f213791964f9706aa59b192"
//   }
// }
var Task = /** @class */ (function () {
    function Task() {
    }
    /**
     * 任务列表
     */
    Task.prototype.getTaskList = function (context, _a, _b) {
        var userInfo = _a.userInfo, vipInfo = _a.vipInfo, activityInfo = _a.activityInfo, session = _a.session;
        var taskService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var tasks, updatedUserInfo, _c, _d, _e, _f, vipTask, followTask;
            return __generator(this, function (_g) {
                switch (_g.label) {
                    case 0:
                        tasks = activityInfo.tasks;
                        _d = (_c = taskService).updateTasks;
                        _e = [userInfo._id];
                        _f = [taskService.updateVipTaskStatus(userInfo, vipInfo, tasks)];
                        return [4 /*yield*/, taskService.updateOrderGoodsTask(userInfo, tasks, session)];
                    case 1: return [4 /*yield*/, _d.apply(_c, _e.concat([_f.concat([
                                _g.sent()
                            ])]))
                        // 会员任务
                    ];
                    case 2:
                        updatedUserInfo = _g.sent();
                        vipTask = taskService.initVipTask(updatedUserInfo, vipInfo, tasks);
                        followTask = taskService.initFollowTask(updatedUserInfo, tasks);
                        // // 下单任务
                        // const orderGoodsTask = taskService.initOrderGoodsTask(updatedUserInfo, tasks)
                        // // 浏览商品任务
                        // const browseGoodsTask = taskService.initBrowseGoodsTask(updatedUserInfo, tasks)
                        // // 邀请任务
                        // const invitesTask = taskService.initInvitesTask(updatedUserInfo, tasks)
                        // 积分兑换
                        //const exchangeCreditsTask = taskService.initExchangeCreditsTask(updatedUserInfo, tasks)
                        return [2 /*return*/, sdk_1.resultsModel.success([vipTask, followTask])];
                }
            });
        });
    };
    /**
     *  完成关注店铺任务
     */
    Task.prototype.doFollowTask = function (context, _a, _b) {
        var userInfo = _a.userInfo, activityInfo = _a.activityInfo;
        var TaskService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var follow, flag, newFollow, hasFollowed, result;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        follow = userInfo.follow;
                        flag = follow.flag, newFollow = follow.newFollow;
                        hasFollowed = flag || newFollow;
                        if (hasFollowed)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_TASK_COMPLETE)
                                // 更新状态
                            ];
                        return [4 /*yield*/, TaskService.updateFollowTask(userInfo, activityInfo)];
                    case 1:
                        result = _c.sent();
                        return [2 /*return*/, result ? sdk_1.resultsModel.success(true) : sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR)];
                }
            });
        });
    };
    /**
     *  积分兑换次数
     */
    Task.prototype.doExchangeCreditsTask = function (context, _a, _b) {
        var userInfo = _a.userInfo, activityInfo = _a.activityInfo, session = _a.session;
        var userService = _b[0], taskService = _b[1];
        return __awaiter(this, void 0, void 0, function () {
            var openId, credits, _id, taskInfo, taskType, _c, value, times, taskRateType, today, todayTimes, myCredits, result;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        openId = context.openId;
                        credits = context.data.credits;
                        _id = userInfo._id, taskInfo = userInfo.taskInfo;
                        taskType = "exchangeCredits";
                        _c = activityInfo.tasks.exchangeCredits, value = _c.value, times = _c.times, taskRateType = _c.taskRateType;
                        today = utils_1.getToday();
                        todayTimes = taskService.getTodayCompleteTask(taskType, userInfo).todayTimes;
                        // 如果每日限制次数并到达了限制次数
                        if (times && times === todayTimes && taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_TASK_LIMIT)];
                        }
                        return [4 /*yield*/, sdk_1.TBAPIS.queryCredits(context, session)];
                    case 1:
                        myCredits = _d.sent();
                        console.log('myCredits', myCredits);
                        // 积分不足
                        if (myCredits < credits)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_NO_CREDITS)
                                // 扣积分
                            ];
                        return [4 /*yield*/, sdk_1.TBAPIS.changeCredits(context, session, {
                                quantity: +credits,
                                change_type: 2,
                                opt_type: '1',
                                remark: "\u79EF\u5206\u5151\u6362\u4EFB\u52A1\u51CF\u79EF\u5206"
                            })];
                    case 2:
                        result = _d.sent();
                        if (!result)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR)
                                // 更新user表
                            ];
                        // 更新user表
                        return [4 /*yield*/, taskService.updateUserTaskRecord(taskType, value, userInfo)];
                    case 3:
                        // 更新user表
                        _d.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(true)];
                }
            });
        });
    };
    /**
     * 浏览商品
     */
    Task.prototype.doBrowseGoodsTask = function (context, _a, _b) {
        var userInfo = _a.userInfo, activityInfo = _a.activityInfo;
        var taskService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var taskType, itemId, _c, taskRateType, times, itemIds, value, itemIdArray, _d, todayTaskInfo, todayTimes, hasCompleteToday;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        taskType = 'browseGoods';
                        itemId = context.data.itemId;
                        _c = activityInfo.tasks.browseGoods, taskRateType = _c.taskRateType, times = _c.times, itemIds = _c.itemIds, value = _c.value;
                        itemIdArray = Array.isArray(itemIds) ? itemIds : itemIds.split(',').map(function (v) { return +v; });
                        // B端配置商品ids不匹配正确
                        if (!itemIdArray.includes(+itemId))
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, '商品id不匹配')];
                        _d = taskService.getTodayCompleteTask('browseGoods', userInfo), todayTaskInfo = _d.todayTaskInfo, todayTimes = _d.todayTimes;
                        hasCompleteToday = todayTaskInfo.filter(function (v) { return v.itemId === itemId; }).length &&
                            taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY;
                        // 今日任务已经完成
                        if (hasCompleteToday) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, '今日该商品任务已完成')];
                        }
                        // 次数超限
                        if (times && times === todayTimes && taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_TASK_LIMIT)];
                        }
                        // 更新user表
                        return [4 /*yield*/, taskService.updateUserTaskRecord(taskType, value, userInfo, {
                                itemId: itemId
                            })];
                    case 1:
                        // 更新user表
                        _e.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(true)];
                }
            });
        });
    };
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.userCheck({ intercept: true }),
        decorator_1.activityTimeCheck,
        decorator_1.services([service_1.TaskService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], Task.prototype, "getTaskList", null);
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.activityTimeCheck,
        decorator_1.services([service_1.TaskService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], Task.prototype, "doFollowTask", null);
    __decorate([
        decorator_1.paramsCheck(['activityId', 'credits']),
        decorator_1.userCheck({ intercept: true }),
        decorator_1.activityTimeCheck,
        decorator_1.services([service_1.UserService, service_1.TaskService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], Task.prototype, "doExchangeCreditsTask", null);
    __decorate([
        decorator_1.paramsCheck(['activityId', 'itemId']),
        decorator_1.userCheck({ intercept: true }),
        decorator_1.activityTimeCheck,
        decorator_1.services([service_1.TaskService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], Task.prototype, "doBrowseGoodsTask", null);
    return Task;
}());
exports.default = Task;
//# sourceMappingURL=task.controller.js.map