/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export const commonToast = (content, duration = 3000, successCb) => {
  return '暂不支持toast';
};

/**
 * 简易alert
 * @param {string} content toast内容
 */
export const simpleAlert = content => {
  alert(content);
};

/**
 * 通用确认弹窗
 * @param {string} title 标题
 * @param {string} content 内容
 * @param {function} successCb 成功回调
 */
export const commonConfirm = (title = '提示', content, successCb) => {
  my.confirm({
    title,
    content,
    confirmButtonText: '确定',
    cancelButtonText: '取消',
    success: result => {
      const { confirm } = result;
      if (confirm) {
        successCb && successCb();
      }
    }
  });
};

/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
export const getAuthUserInfo = async () => {
  return {
    nickName: 'nickName',
    avatar: '123',
    mixNick: '1234'
  };
};

/**
 * 获取系统信息
 * @returns {object} 小程序系统信息
 */
export const getSystemInfo = async () => {
  return {
    version: '9.5.0'
  };
};

/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export const favorShop = async sellerId => {
  if (!sellerId) {
    console.error('favorShop: 请传入卖家Id');
    return false;
  }
  return {};
};

/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export const checkShopFavoredStatus = async sellerId => {
  if (!sellerId) {
    console.error('checkShopFavoredStatus: 请传入卖家Id');
    return false;
  }
  return true;
};

/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
export const navigateToOutside = url => {
  if (!url) {
    console.error('navigateToOutside: 请传入url');
    return false;
  }
  window.location = url;
};

/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
export const navigateTo = url => {
  if (!url) {
    console.error('navigateTo: 请传入url');
    return false;
  }
  window.location = url;
};

/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url 跳转链接
 */
export const redirectTo = url => {
  if (!url) {
    console.error('redirectTo: 请传入url');
    return false;
  }
  window.replace(url);
};

/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
export const getServerTime = async () => {
  return +new Date();
};

/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
export const collectGoods = async id => {
  if (!id) {
    console.error('collectGoods: 请传入商品id');
    return false;
  }
  return {};
};

/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
export const checkGoodsCollectedStatus = async id => {
  if (!id) {
    console.error('checkGoodsCollectedStatus: 请传入商品id');
    return false;
  }
  return true;
};

/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
export const openDetail = async itemId => {
  if (!itemId) {
    console.error('openDetail: 请传入商品id');
    return false;
  }
  window.location = 'https://item.taobao.com/item.htm?id=' + itemId;
};

/**
 * 获取淘宝用户收货地址
 */
export const getUserAddress = async (opts = {}) => {
  return {
    name: 1,
    phone: 1,
    address: 123
  }
};

/**
 * 选择图片
 */
export const chooseImage = async (opts = {}) => {
  let defaults = {
    count: 1,
    sourceType: ['camera', 'album'],
    compressLevel: 1
  };
  let _opts = Object.assign({}, defaults, opts);
  const { count, sourceType, compressLevel } = _opts;
  return new Promise((resolve, reject) => {
    if (!my.chooseImage) {
      reject({
        noSupport: true,
        errorMessage: '当前版本不支持选择收货地址，请升级到最新版本'
      });
      return false;
    }
    my.chooseImage({
      count,
      sourceType,
      success: res => {
        my.compressImage({
          apFilePaths: res.apFilePaths,
          level: compressLevel,
          success: data => {
            resolve(data);
          },
          fail: err => {
            resolve(err);
          }
        });
      },
      fail: err => {
        // error code 2001 为摄像头授权取消、ios 11为用户取消操作不认作失败场景 、安卓 为1
        if (err.error !== 2001 && err.error !== 11 && err.error !== 1) {
          reject(err);
        } else {
          resolve(false);
        }
      }
    });
  });
};

/**
 * 获取图片信息
 * @param {string} src 图片地址
 */
export const getImageInfo = async src => {
  return new Promise((resolve, reject) => {
    my.getImageInfo({
      src,
      success: res => {
        resolve(res);
      },
      fail: err => {
        reject(err);
      }
    });
  });
};

/**
 * 获取图片信息
 * @param {*} opts chooseImage配置参数
 */
export const uploadImage = async (opts = {}) => {
  const { cloud } = getApp();
  if (!cloud) {
    console.error('chattingSendCard: 请传入app.cloud');
    return false;
  }
  const chooseImageResult = await chooseImage(opts).catch(err => {
    commonToast(err && (err.errorMessage || '选择图片失败'));
  });
  if (chooseImageResult) {
    const { apFilePaths } = chooseImageResult;
    const filePath = apFilePaths[0];
    const imageInfo = await getImageInfo(filePath).catch(err => {
      commonToast(err && err.errorMessage);
    });
    // 找不到图片信息
    if (!imageInfo) {
      return false;
    }
    const { path: imagePath } = imageInfo;
    const { url } = await cloud.file.uploadFile({
      filePath,
      fileType: 'image',
      fileName: imagePath.split('/').pop()
    });
    return url;
  }
  return false;
}

/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export const chattingSendCard = async (requestInfo) => {
  alert('无法模拟');
  return false;
};

/**
 * 分享到群聊卡片
 * @param {*} cloud 小程序云
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export const textRiskIdentification = async (text) => {
  return true;
}