"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var service_1 = require("../service");
var saveValidate_1 = require("../utils/saveValidate");
var ActivitSaveController = /** @class */ (function () {
    function ActivitSaveController() {
    }
    /**
     *  保存活动
     */
    // @paramsCheck(['title', 'startTime', 'endTime', 'tasks', 'rule'])
    ActivitSaveController.prototype.saveActivityInfo = function (context, _a, _b) {
        var activityconfigService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var _c, _d, title, _e, activityId, startTime, endTime, _f, tasks, rule, prizeList, data, openId, baseData, allPrizeList, result, result, _g, bothIds, deleteIds, prizeResult;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        _c = context.data, _d = _c.title, title = _d === void 0 ? '' : _d, _e = _c.activityId, activityId = _e === void 0 ? '' : _e, startTime = _c.startTime, endTime = _c.endTime, _f = _c.tasks, tasks = _f === void 0 ? {} : _f, rule = _c.rule, prizeList = _c.prizeList, data = __rest(_c, ["title", "activityId", "startTime", "endTime", "tasks", "rule", "prizeList"]);
                        openId = context.openId;
                        baseData = __assign(__assign({ title: title,
                            startTime: startTime,
                            endTime: endTime,
                            rule: rule,
                            openId: openId,
                            tasks: tasks }, data), { 
                            // 奖品过期时间, 根据需求领奖是否有过期时间
                            awardReceiveExpiredTime: endTime + constants_1._48_HOURS });
                        allPrizeList = __spreadArrays(prizeList.map(function (v, i) { return (__assign(__assign({}, v), { level: i + 1 })); }));
                        if (!!activityId) return [3 /*break*/, 2];
                        return [4 /*yield*/, activityconfigService.saveNewActivity(baseData, allPrizeList, openId)];
                    case 1:
                        result = _h.sent();
                        if (result || result === 0) {
                            return [2 /*return*/, sdk_1.resultsModel.success(true)];
                        }
                        else {
                            console.log(result, '保存活动失败');
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '保存活动失败')];
                        }
                        return [3 /*break*/, 9];
                    case 2: return [4 /*yield*/, activityconfigService.updateBaseConfigInfo(activityId, baseData)
                        // 找到更新的和删除的奖品id
                    ];
                    case 3:
                        result = _h.sent();
                        return [4 /*yield*/, activityconfigService.diffPrizeList(activityId, allPrizeList)
                            // 将删除的奖品逻辑删除
                        ];
                    case 4:
                        _g = _h.sent(), bothIds = _g.bothIds, deleteIds = _g.deleteIds;
                        if (!(deleteIds === null || deleteIds === void 0 ? void 0 : deleteIds.length)) return [3 /*break*/, 6];
                        return [4 /*yield*/, activityconfigService.deletePrizeByIds(deleteIds)];
                    case 5:
                        result = _h.sent();
                        _h.label = 6;
                    case 6:
                        if (!(allPrizeList === null || allPrizeList === void 0 ? void 0 : allPrizeList.length)) return [3 /*break*/, 8];
                        return [4 /*yield*/, activityconfigService.insertAndUpdatePrize(activityId, allPrizeList, bothIds)];
                    case 7:
                        prizeResult = _h.sent();
                        if (prizeResult.failed.length) {
                            console.log(prizeResult.failed, '更新奖品失败');
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '保存活动失败')];
                        }
                        _h.label = 8;
                    case 8:
                        if (result || result === 0) {
                            return [2 /*return*/, sdk_1.resultsModel.success(true)];
                        }
                        else {
                            console.log(result, '保存活动失败');
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '保存活动失败')];
                        }
                        _h.label = 9;
                    case 9: return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        decorator_1.paramsValidate(saveValidate_1.saveParams),
        decorator_1.services([service_1.ActivityconfigService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], ActivitSaveController.prototype, "saveActivityInfo", null);
    return ActivitSaveController;
}());
exports.default = ActivitSaveController;
//# sourceMappingURL=save.controller.js.map