/** @format */

import { CODE_TYPES, _48_HOURS } from './../constants'
import { services, paramsCheck, paramsValidate } from '../decorator'
import { resultsModel, TBAPIS } from '../sdk'
import { ActivityconfigService } from '../service'
import { saveParams } from '../utils/saveValidate'

// 奖品参数
export interface ISavePrizeParams {
  prizeList?: Array<IActivityPrize>
}

// interface IActivityInfo {
//   baseConfig: IActivityBaseInfo
//   prizeConfig: Array<IActivityPrize>
// }

export interface ISaveActivityContext extends Context {
  data: IActivityBaseInfo & ISavePrizeParams
}

export default class ActivitSaveController {
  /**
   *  保存活动
   */
  // @paramsCheck(['title', 'startTime', 'endTime', 'tasks', 'rule'])
  @paramsValidate(saveParams)
  @services([ActivityconfigService])
  async saveActivityInfo(context: ISaveActivityContext, { }, [activityconfigService]: [ActivityconfigService]) {
    let {
      title = '',
      activityId = '',
      startTime, endTime,
      tasks = {}, rule,
      prizeList,
      ...data
    } = context.data
    const { openId } = context

    // 存在b_activity_config表里属于基础配置
    const baseData: IActivityBaseInfo = {
      title,
      startTime,
      endTime,
      rule,
      openId,
      tasks,
      ...data,
      // 奖品过期时间, 根据需求领奖是否有过期时间
      awardReceiveExpiredTime: endTime + _48_HOURS
    }

    // 概率奖品配置需要增加 properiodfrom properiodto字段 -- 改为前端添加（因为多个奖池合并跑下面的方法概率会出问题）
    // prizeList = activityconfigService.setPrizeProbalityRange(prizeList)

    // 所有奖品均存在b_prize_config表里,  根据需求定义的奖品参数都要整合到allPrizeLists里
    // level 排序用避免查询乱序
    const allPrizeList: Array<IActivityPrize> = [...prizeList.map((v, i) => ({ ...v, level: i + 1 }))]

    // 保存新活动
    if (!activityId) {
      // 所有奖品均存在b_prize_config表里,  根据需求定义的奖品参数都要整合到prizeList里
      const result = await activityconfigService.saveNewActivity(baseData, allPrizeList, openId)
      if (result || result === 0) {
        return resultsModel.success(true)
      } else {
        console.log(result, '保存活动失败')
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '保存活动失败')
      }
    }
    // 有activityId 属于修改活动
    else {
      // 更新b_activity_config基础信息
      let result = await activityconfigService.updateBaseConfigInfo(activityId, baseData)

      // 找到更新的和删除的奖品id
      const { bothIds, deleteIds } = await activityconfigService.diffPrizeList(activityId, allPrizeList)

      // 将删除的奖品逻辑删除
      if (deleteIds?.length) {
        result = await activityconfigService.deletePrizeByIds(deleteIds)
      }

      if (allPrizeList?.length) {
        // 添加和更新奖品
        const prizeResult = await activityconfigService.insertAndUpdatePrize(activityId, allPrizeList, bothIds)
        if (prizeResult.failed.length) {
          console.log(prizeResult.failed, '更新奖品失败')
          return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '保存活动失败')
        }
      }

      if (result || result === 0) {
        <%if (miniConfig.needMiniapp && miniConfig.MiniappIdList.length > 0) {%>
          try {
          <% for (var i = 0; i < miniConfig.MiniappIdList.length; ++i) { %>
            <%- `await TBAPIS.configMiniApp(context, {appId: ${+miniConfig.MiniappIdList[i]},version:'0.0.1'})` %>
          <% } %>
          } catch (error) {
              console.log(error)
          }
        <%}%>
        return resultsModel.success(true)
    } else {
      console.log(result, '保存活动失败')
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, '保存活动失败')
    }
  }
}
}
