const request = ({ cloud, cloudName, requestType = 'cloud', mockUrl }) => {
  if (!cloud) {
    console.error('请传入cloud');
    return false;
  }
  if (!cloudName) {
    console.error('请传入云函数名称');
    return false;
  }
  return async (handle, method, params, ext = {}) => {
    const { activityId } = getApp();
    // 默认注入activityId
    params = { activityId, ...params };
    if (!params.activityId) {
      console.error(`${handle}:请传入activityId`);
      return false;
    }
    const _cloudName = ext.cloudName || cloudName;
    const { isShowLoading } = ext;
    const hideMyLoading = () => {
      if (isShowLoading) {
        my.hideLoading();
      }
    };
    if (isShowLoading) {
      my.showLoading();
    }
  
    const requestMock = () => {
      const mockUrlPrefix = {
        ams: 'https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=',
        yapi: 'https://docs.dui88.com/mock/140/'
      };
      const requestPrefix = mockUrl || mockUrlPrefix[requestType];
      return new Promise((resolve, reject) => {
        my.request({
          url: requestPrefix + _cloudName + '.' + handle,
          method,
          data: params,
          dataType: 'json'
        }).then(({ data: res }) => {
          hideMyLoading();
          if (res && res.success) {
            resolve(res);
          } else {
            reject(res);
          }
        }).catch(() => {
          hideMyLoading();
          reject();
        });
      })
    };

    const requestCloud = () => {
      return new Promise((resolve, reject) => {
        cloud.function.invoke(_cloudName, params, handle).then(res => {
          console.log(handle, params, res);
          hideMyLoading();
          if (res && res.success) {
            resolve(res);
          } else {
            reject(res);
          }
          return res;
        }).catch(() => {
          hideMyLoading();
          reject();
        });
      });
    };
  
    return ['ams', 'yapi'].includes(requestType) ? requestMock() : requestCloud();
  };
};

export default request;