/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { dbCount } from '../mongodb'
import { SIGN_DB_NAME } from '../../../db'
import { getToday } from '../getToday'

export default async function checkSign(
  context: IContext<{
    activityId: string
    subscribeSignDay?: string
  }>,
  { userInfo }: IControllerInfos
) {
  const { activityId, subscribeSignDay } = context.data
  const { openId } = context
  const todaySigned = await dbCount(context, SIGN_DB_NAME, {
    activityId,
    openId,
    signDay: subscribeSignDay || getToday()
  })

  if (todaySigned) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '今日已签到~')
}
