/** @format */
//加法
export function add(num1: number, num2: number): number {
  const num1Decimal = num1.toString().split('.')[1] || ''
  const num2Decimal = num2.toString().split('.')[1] || ''
  const num1DecimalLength = num1Decimal.length
  const num2DecimalLength = num2Decimal.length
  //计算小数位数位数差值
  if (num1DecimalLength >= num2DecimalLength) {
    //如果前一位比后一位大，则后一位补位计算精度
    return (
      (num1 * Math.pow(10, num1DecimalLength + 1) +
        num2 * Math.pow(10, num2DecimalLength + 1) * Math.pow(10, num1DecimalLength - num2DecimalLength)) /
      Math.pow(10, num1DecimalLength + 1)
    )
  } else {
    return (
      (num2 * Math.pow(10, num2DecimalLength + 1) +
        num1 * Math.pow(10, num1DecimalLength + 1) * Math.pow(10, num2DecimalLength - num1DecimalLength)) /
      Math.pow(10, num2DecimalLength + 1)
    )
  }
}
//减法
export function subtract(num1: number, num2: number): number {
  const num1Decimal = num1.toString().split('.')[1] || ''
  const num2Decimal = num2.toString().split('.')[1] || ''
  const num1DecimalLength = num1Decimal.length
  const num2DecimalLength = num2Decimal.length
  //计算小数位数位数差值
  if (num1DecimalLength >= num2DecimalLength) {
    //如果前一位比后一位大，则后一位补位计算精度
    return (
      (num1 * Math.pow(10, num1DecimalLength + 1) -
        num2 * Math.pow(10, num2DecimalLength + 1) * Math.pow(10, num1DecimalLength - num2DecimalLength)) /
      Math.pow(10, num1DecimalLength + 1)
    )
  } else {
    return (
      (num1 * Math.pow(10, num1DecimalLength + 1) * Math.pow(10, num2DecimalLength - num1DecimalLength) -
        num2 * Math.pow(10, num2DecimalLength + 1)) /
      Math.pow(10, num2DecimalLength + 1)
    )
  }
}
//乘法
export function multiply(num1: number, num2: number): number {
  const num1Decimal = num1.toString().split('.')[1] || ''
  const num2Decimal = num2.toString().split('.')[1] || ''
  const num1DecimalLength = num1Decimal.length
  const num2DecimalLength = num2Decimal.length
  //计算小数位数位数差值
  return (
    (num1 * Math.pow(10, num1DecimalLength + 1) * (num2 * Math.pow(10, num2DecimalLength + 1))) /
    Math.pow(10, num1DecimalLength + num2DecimalLength + 2)
  )
}

//除法
export function divide(num1: number, num2: number): number {
  const num1Decimal = num1.toString().split('.')[1] || ''
  const num2Decimal = num2.toString().split('.')[1] || ''
  const num1DecimalLength = num1Decimal.length
  const num2DecimalLength = num2Decimal.length
  //计算小数位数位数差值
  if (num1DecimalLength >= num2DecimalLength) {
    //如果前一位比后一位大，则后一位补位计算精度
    return (
      (num1 * Math.pow(10, num1DecimalLength + 1)) /
      (num2 * Math.pow(10, num2DecimalLength + 1) * Math.pow(10, num1DecimalLength - num2DecimalLength))
    )
  } else {
    return (
      (num1 * Math.pow(10, num1DecimalLength + 1) * Math.pow(10, num2DecimalLength - num1DecimalLength)) /
      (num2 * Math.pow(10, num2DecimalLength + 1))
    )
  }
}
