/** @format */
import { services, checkParams, preCheck, registeInfos } from '../../decorator/common'
import {
  checkPrizeExpired,
  checkValidObjectPrize,
  checkValidEnamePrize,
  checkActivityTime
} from '../../utils/common/check'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonAwardsService } from '../../service/common'

export default class AwardsController {
  /**
   *  我的奖品列表
   */
  @checkParams(['activityId'])
  @services([CommonAwardsService])
  async getMyPrizeList(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonAwardsService]: [CommonAwardsService]
  ) {
    const commonAwardsGetMyPrizeListResult1 = await commonAwardsService.getMyPrizeList(activityInfo)
    return resultsModel.success({
      ...commonAwardsGetMyPrizeListResult1
    })
  }
  /**
   *  领取实物
   */
  @checkParams(['activityId', 'id', 'name', 'phone', 'province', 'city', 'area', 'addressDetail', 'streetName'])
  @services([CommonAwardsService])
  @preCheck([checkPrizeExpired, checkValidObjectPrize])
  async receiveObjectPrize(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonAwardsService]: [CommonAwardsService],
    { awardInfo }: IPreCheckData
  ) {
    const commonAwardsRecieveObjectPrizeResult1 = await commonAwardsService.recieveObjectPrize(context)
    return resultsModel.success({
      ...commonAwardsRecieveObjectPrizeResult1
    })
  }
  /**
   *  领取权益
   */
  @checkParams(['activityId', 'id'])
  @registeInfos(['session'])
  @services([CommonAwardsService])
  @preCheck([checkPrizeExpired, checkValidEnamePrize])
  async receiveEnamePrize(
    context: IContext<IParams>,
    { activityInfo, userInfo, session }: IControllerInfos,
    [commonAwardsService]: [CommonAwardsService],
    { awardInfo }: IPreCheckData
  ) {
    const commonAwardsRecieveEnamePrizeResult1 = await commonAwardsService.recieveEnamePrize(
      context.data.id,
      awardInfo,
      session
    )
    return resultsModel.success({
      ...commonAwardsRecieveEnamePrizeResult1
    })
  }
  /**
   *  概率抽奖
   */
  @checkParams(['activityId', 'prizeDataType'])
  @registeInfos(['session'])
  @services([CommonAwardsService])
  @preCheck([checkActivityTime])
  async drawLotteryPrize(
    context: IContext<IParams>,
    { activityInfo, userInfo, session }: IControllerInfos,
    [commonAwardsService]: [CommonAwardsService]
  ) {
    const commonAwardsDrawLotteryResult1 = await commonAwardsService.drawLottery(
      context.data.activityId,
      context.data.prizeDataType,
      userInfo
    )
    return resultsModel.success({
      ...commonAwardsDrawLotteryResult1
    })
  }
}
