/** @format */

import { BaseDao } from '../../sdk'

export async function dbFindOne<T>(context: IContext<IParams>, dbName: string, query: IMongoQuery) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.findOne<T>(query)
}

export async function dbFind<T>(context: IContext<IParams>, dbName: string, query: IMongoQuery) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.find<T>(query)
}

export async function dbCount(context: IContext<IParams>, dbName: string, query: IMongoQuery) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.count(query)
}

export async function dbUpdate(context: IContext<IParams>, dbName: string, query: object, options?: IUpdateQuery) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.update(query, options)
}

export async function dbInsertOne(context: IContext<IParams>, dbName: string, document: any) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.insertOne(document)
}

export async function dbInsertMany(context: IContext<IParams>, dbName: string, document: object[]) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.insertMany(document)
}

export async function dbAggregate(
  context: IContext<IParams>,
  dbName: string,
  pipeline: object | object[],
  options?: object
) {
  const dao: IBaseDao = new BaseDao(context, dbName)
  return await dao.aggregate(pipeline, options)
}
