/** @format */

import { services, checkParams, registeInfos, noCheckUser } from '../decorator/common'
import { resultsModel } from '../sdk'
import { CommonBaseService } from '../service/common'
export default class BaseController {
  /**
   *  活动基本信息
   */
  @checkParams(['activityId'])
  @noCheckUser
  @services([CommonBaseService])
  async getActivityBaseInfoById(
    context: IContext<{
      activityId: string
    }>,
    {}: IControllerInfos,
    [baseService]: [CommonBaseService]
  ): Promise<IResult<IActivityInfo>> {
    const { activityId } = context.data
    const activityInfo = await baseService.getBaseInfo(activityId)
    return resultsModel.success({
      ...activityInfo
    })
  }

  /**
   * 获取商品列表
   */
  @checkParams(['itemIds'])
  @registeInfos(['session'])
  @services([CommonBaseService])
  async getTaobaoItemList(
    context: IContext<IParams>,
    { session }: IControllerInfos,
    [baseService]: [CommonBaseService]
  ): Promise<IResult<{ list: ITaoBaoItems[] }>> {
    const { itemIds } = context.data

    const list = await baseService.getItemListByIds(itemIds, session)

    return resultsModel.success({
      ...list
    })
  }
}
