/** @format */

import { getToday } from './getToday'
/**
 * 判断是否新会员
 *
 * @format
 * @param {IUserInfo} userInfo
 * @param {IVipInfo} vipInfo
 * @returns {boolean}
 * @memberof UserService
 */

export function checkNewVip(userInfo: IUserInfo, vipInfo: IVipInfo): boolean {
  const {
    member: { flag }
  } = userInfo

  const { isVip } = vipInfo

  return !flag && isVip
}

export function setNewVipUserData(member: IMemberInfo): IMemberInfo {
  const today = getToday()
  return {
    ...member,
    newMember: true,
    bememberTime: Date.now(),
    bememberDay: today
  }
}

export function setNewFollowUserData(follow: IFollowInfo): IFollowInfo {
  const today = getToday()
  return {
    ...follow,
    newFollow: true,
    followTime: Date.now(),
    followDay: today
  }
}
