/**
 *  updateUser projection 格式化
 *
 * @format
 * @param {object} projection
 * @return {*}
 * @memberof UserService
 */

export function formatUpdateUserProjection(projection: IUpdateQuery): IUpdateQuery {
  projection['$set'] = projection['$set'] || {}
  projection['$set'].updateTime = Date.now()
  // $push不存在属性  删除$push
  if (projection['$push'] && !Object.keys(projection['$push']).length) {
    delete projection['$push']
  }
  console.log(projection)
  return projection
}

// 用户昵称脱敏
export function formatUserNick(name: string) {
  let newStr: string
  if (name.length === 2) {
    newStr = name.substr(0, 1) + '***' + name.substr(-1, 1)
  } else if (name.length > 2) {
    let char = '***'
    newStr = name.substr(0, 1) + char + name.substr(-1, 1)
  } else {
    newStr = name + '***'
  }
  return newStr
}
