/** @format */
interface IActivityInfo {
  _id?: string
  id?: string
  openId: string
  rule: string
  startTime: number
  endTime: number
  title: string
  deleteStatus: number
  openPrizeStatus?: number
  remark?: string
  createTime: number
  updateTime: number
  awardReceiveExpiredTime?: number
  tasks?: ITasks
}
type ITaskType =
  | 'follow'
  | 'member'
  | 'sign'
  | 'exchangeCredits'
  | 'browseGoods'
  | 'orderGoods'
  | 'collectGoods'
  | 'jumpLink'
  | 'invites'

type ITasks = { [key in ITaskType]: ITaskConfig }
// interface ITasks {
//   // follow?: ITaskConfig
//   // member?: ITaskConfig
//   // sign?: ITaskConfig
//   // exchangeCredits?: ITaskConfig
//   // browseGoods?: ITaskConfig
//   // orderGoods?: ITaskConfig
//   // collectGoods?: ITaskConfig
//   // jumpLink?: ITaskConfig
//   // invites?: ITaskConfig
//   [key in ITaskType]: ITaskConfig
// }

interface ITaskConfig {
  title?: string // 任务标题
  value: number // 任奖奖励
  times?: number // 任务为每日限次次数值
  taskRateType?: number // 任务频率类型
  link?: string // 任务链接
  itemIds?: string // 任务商品
  checked?: boolean // 是否选中（B端需勾选时）
}

interface IActivityPrize {
  _id?: string
  id?: string
  activityId?: string
  ename?: string
  prizeDataType: number
  type: number
  image?: string
  name: string
  probability?: string | number
  properiodto?: number
  properiodfrom?: number
  lockStatus?: number
  switchStock?: number
  rank?: string | number
  credits?: string | number
  useUrl?: string
  stock?: number
  useStock?: number
  openId?: string
  deleteStatus?: number
  createTime?: number
  updateTime?: number
}
