/**
 * 基本信息
 *
 * @format
 */

import { BaseDao } from '../sdk'
import { STAT_DB_NAME } from '../db'
import { getToday } from '../utils'
import { STAT_TYPE } from '../constants'

export default class StatService {
  context: IContext<any>
  statdao: IBaseDao
  constructor(context: IContext<IParams>) {
    this.context = context
    this.statdao = new BaseDao(context, STAT_DB_NAME)
  }

  /**
   *  添加数据统计记录
   *
   * @param {number} type  数据类型
   * @param {object} [customStatData={}] 自定义数据
   * @param {IUserInfo} [userInfo] 用户信息
   * @return {boolean}
   * @memberof StatService
   */
  async addStat(type: number, userInfo: IUserInfo = {} as IUserInfo, customStatData: object = {}): Promise<string> {
    const { openId } = this.context
    const { activityId } = this.context.data
    const { userNick } = userInfo
    return await this.statdao.insertOne({
      activityId,
      type,
      typeName: STAT_TYPE[type],
      userNick,
      openId,
      ...customStatData,
      createTime: Date.now(),
      createDay: getToday()
    })
  }

  async getStatCountByquery(query: IMongoQuery) {
    return await this.statdao.count(query)
  }
}
