/** @format */

import { logFn, recordErrorLog } from '../utils'
import { resultsModel } from '../sdk'
import { CODE_TYPES } from '../constants'

type Constructor = new (...args: any[]) => {}

// 注入服务
export const services = (services: Constructor[]) => {
  return (target: Object, name: string, descriptor: PropertyDescriptor) => {
    const method = descriptor.value

    descriptor.value = async function (...args: any[]) {
      let [context, otherArgs = {}] = args
      const servicesInstance = services.map(v => new v(context))

      logFn(context)

      const baseInfos = otherArgs

      // 默认全局try catch  如果有noCatch参数则直接执行
      if (baseInfos.noCatch) {
        delete baseInfos.noCatch
        return method.apply(target, [context, baseInfos, servicesInstance])
      }
      let ret: IResult<any>
      try {
        ret = await method.apply(target, [context, baseInfos, servicesInstance])
      } catch (error) {
        console.log('error', error)
        await recordErrorLog(context, baseInfos, error.toString(), error.stack)
        ret = resultsModel.error(CODE_TYPES.SYSTEM_ERROR)
      }
      return ret
    }
  }
}
