/** @format */
import { UserService, BaseService } from '../service'
import { getSellerSession } from '../utils'
import { formatVipCbUrl, getShopVip } from '../utils/package/vip'

export type IInfo = 'userInfo' | 'session' | 'activityInfo' | 'vipInfo'

async function initBaseInfo(context: IContext<IParams>, baseInfos: IControllerInfos, needInfos: IInfo[]) {
  const handler = context?.cloud?.dataspace?.context?.handler
  const userService = new UserService(context)

  if (needInfos.includes('userInfo') && !baseInfos.userInfo) {
    const userInfo = await userService.getUserInfo()
    baseInfos.userInfo = userInfo
  }

  if (needInfos.includes('session') && !baseInfos.session) {
    const { session, userNick } = await getSellerSession(context)
    baseInfos.session = session
    baseInfos.activityUserNick = userNick
  }

  if (needInfos.includes('activityInfo') && !baseInfos.activityInfo) {
    const baseService = new BaseService(context)

    // 活动基本情况
    const activityInfo = await baseService.getBaseInfo(context.data.activityId)
    baseInfos.activityInfo = activityInfo
  }

  if (needInfos.includes('vipInfo') && !baseInfos.vipInfo && handler !== 'getVipInfo') {
    if (!baseInfos.session) {
      const { session, userNick } = await getSellerSession(context)
      baseInfos.session = session
      baseInfos.activityUserNick = userNick
    }
    const vipInfo = await getShopVip(context, baseInfos.session, formatVipCbUrl(context), baseInfos.activityUserNick)
    baseInfos.vipInfo = vipInfo
  }
  return baseInfos
}

export const registeInfos = (needInfos: IInfo[]) => {
  return function (target: any, name: string, descriptor: PropertyDescriptor) {
    const method = descriptor.value
    descriptor.value = async function (...args: any[]) {
      const [context, otherArgs = {}] = args

      const baseInfo = await initBaseInfo(context, otherArgs, needInfos)

      return method.apply(target, [context, { ...baseInfo }])
    }
  }
}
