/** @format */

import { CODE_TYPES } from './../constants'
import { services, paramsCheck, registeInfos } from '../decorator'

import { resultsModel } from '../sdk'
import { logger } from '../utils'
import { BaseService } from '../service'
export default class BaseController {
  /**
   *  活动基本信息
   */
  @paramsCheck(['activityId'])
  @services([BaseService])
  async getActivityBaseInfoById(
    context: IContext<{
      activityId: string
    }>,
    {},
    [baseService]: [BaseService]
  ): Promise<IResult<IActivityInfo>> {
    const { activityId } = context.data
    // 参数校验
    if (!activityId) {
      return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`)
    }
    // 活动基本情况
    const activityInfo = await baseService.getBaseInfo(activityId)
    return resultsModel.success(activityInfo)
  }

  /**
   * 获取商品列表
   */
  @paramsCheck(['itemIds'])
  @registeInfos(['session'])
  @services([BaseService])
  async getItemListByItemIds(
    context: IContext<{ itemIds: string }>,
    { session }: IControllerInfos,
    [baseService]: [BaseService]
  ): Promise<IResult<ITaoBaoItems[]>> {
    const { itemIds } = context.data

    const list = await baseService.getItemListByIds(itemIds, session)

    return resultsModel.success(list)
  }
}
