/** @format */

var express = require('express')
var bodyParser = require('body-parser')
var cookieParser = require('cookie-parser')
var { createProxyMiddleware } = require('http-proxy-middleware')
const routers = require('../index')
const { port, serverProxy } = require('./package.json')
const { createLogger, format, transports } = require('winston')
const dayjs = require('dayjs')

const logger = createLogger({
  format: format.combine(
    format.splat(),
    format.simple()
  ),
  transports: [
    new transports.Console(),
    new transports.File({ filename: `logger${dayjs().format('YYYY-MM-DD')}.log`, json: true })
  ]
})
var app = express()

app.use(cookieParser())
app.use(
  bodyParser.urlencoded({
    extended: true
  })
)
app.use(bodyParser.json())
app.get('/', (req, res) => {
  res.json({ message: `ok` })
})
var child_process = require('child_process')
app.get('/apiLog', async (req, res) => {
  var child = child_process.spawn('tail', ['-n 500', `logger${dayjs().format('YYYY-MM-DD')}.log`])
  let result = ''
  //打印子进程的输出数据
  child.stdout.on('data', function (data) {
    result += data
  })
  child.stdout.on('error', function (data) {
    result = data
  })
  child.stdout.on('close', function () {
    res.json({ success: true, data: Buffer.from(result).toString() })
  })
})

// 执行本地云函数方法
app.post('/handler', async (req, res) => {
  try {
    let { data, openId, db } = req.body
    let { handler, data: queryData } = data
    logger.info(`--------------------------------------------------`)
    logger.info(`时间: %s`, dayjs().format('YYYY-MM-DD HH:mm:ss'))
    logger.info(`调用接口: %s`, handler)
    logger.info(`调用信息: 用户openId: %s, 项目id: %s`, openId, db)
    logger.info(`接口参数: %s`, queryData)
    try {
      let query = JSON.parse(JSON.stringify(data))
    } catch (e) {
      returnObj({ message: `查询参数格式错误` })
    }
    if (!db) {
      returnObj({ message: `参数错误,缺少数据库db` })
    }
    if (!openId) {
      returnObj({ message: `参数错误,缺少openId` })
    }
    if (!handler) {
      returnObj({ message: `格式错误, handler参数不能为空` })
    }
    if (!queryData) {
      returnObj({ message: `格式错误, data参数不能为空` })
    }
    if (!process.db) {
      process.db = db
    }
    req.context = {
      openId,
      db,
      env: 'mock',
      data: queryData,
      handler
    }
    if (routers[handler]) {
      let result = await routers[handler](req.context)
      returnObj(result)
    } else {
      returnObj({ message: `函数${handler}不存在` })
    }
    // 返回结果
    function returnObj(obj) {
      logger.info(`返回结果: %s`, JSON.stringify(obj))
      res.json(obj)
    }
  } catch (e) {
    logger.error(`运行出错: %s`, e)
  }
})

// 获取本地export的数据库表及云函数
app.get('/getDBHandlers', async (req, res) => {
  let dbs = require('../dist/db')
  let handlers = routers

  // dbsInfo
  let dbArray = []
  let handlerArray = []
  Object.keys(dbs).map(v => {
    dbArray.push(dbs[v])
  })
  Object.keys(handlers).map(v => {
    handlerArray.push(v)
  })
  console.log(dbArray, handlerArray)
  res.json({
    dbs: dbArray,
    handlers: handlerArray,
    success: true
  })
})

const ProxyOption = {
  target: serverProxy.target,
  changeOrigin: true,
  pathRewrite: (path, req) => {
    return path.replace('/proxy', '')
  },
  onProxyReq: (proxyReq, req, res) => {
    if (req.body) {
      let bodyData = JSON.stringify(req.body)
      // incase if content-type is application/x-www-form-urlencoded -> we need to change to application/json
      proxyReq.setHeader('Content-Type', 'application/json')
      proxyReq.setHeader('Content-Length', Buffer.byteLength(bodyData))
      // stream the content
      proxyReq.write(bodyData)
    }
  }
}

app.use('/proxy', createProxyMiddleware(ProxyOption))

app.listen(port || 5555)
