"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatVipCbUrl = exports.generateVipUrl = exports.getShopVip = exports.isUseVipMock = void 0;
var index_1 = require("../../config/index");
var constants_1 = require("../../constants");
var vipMock_1 = require("../../vipMock");
var sdk_1 = require("../../sdk");
/** @format */
// 测试环境 duib2账户mock数据  或者本地
exports.isUseVipMock = function (context, userNick) {
    var isTestEnv = context.env === 'test';
    var isMockEnv = context.env === 'mock';
    var isDuibaAccount = userNick.startsWith('duiba2');
    return (isTestEnv && isDuibaAccount) || isMockEnv;
};
/**
 * @desc 获取是否是会员
 * @param {调用淘宝接口的session} session
 * @returns {isVip: boolean(是否是会员), url: string(入会链接) }
 */
exports.getShopVip = function (context, session, callbackUrl, activityUserNick) {
    if (callbackUrl === void 0) { callbackUrl = ''; }
    if (activityUserNick === void 0) { activityUserNick = ''; }
    return __awaiter(void 0, void 0, void 0, function () {
        var result, shopUrl;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (exports.isUseVipMock(context, activityUserNick)) {
                        return [2 /*return*/, vipMock_1.VIP_MOCK];
                    }
                    result = {
                        result: {
                            member_info: ''
                        }
                    };
                    return [4 /*yield*/, sdk_1.TBAPIS.queryVipinfo(context, session)];
                case 1:
                    result = _a.sent();
                    shopUrl = exports.generateVipUrl(callbackUrl);
                    return [2 /*return*/, {
                            isVip: !!(result.result && result.result.member_info),
                            url: shopUrl
                        }];
            }
        });
    });
};
// 生成会员链接
exports.generateVipUrl = function (callbackUrl) {
    return "https://market.m.taobao.com/app/sj/member-center-rax/pages/pages_index_index?wh_weex=true&sellerId=" + constants_1.sellerId + "&extraInfo=" + encodeURIComponent(JSON.stringify({ source: 'isvapp', entrance: 'duiba' })) + "&callbackUrl=" + encodeURIComponent(callbackUrl);
};
// 格式化Vip回调地址
exports.formatVipCbUrl = function (context) {
    var _a, _b, _c;
    var _d = context.data, activityId = _d.activityId, _e = _d.inviteId, inviteId = _e === void 0 ? '' : _e;
    var vipCallBackUrl = index_1.getConfig(context).vipCallBackUrl;
    var handlerName = (_c = (_b = (_a = context === null || context === void 0 ? void 0 : context.cloud) === null || _a === void 0 ? void 0 : _a.dataspace) === null || _b === void 0 ? void 0 : _b.context) === null || _c === void 0 ? void 0 : _c.handler;
    // 拼接回调参数
    var query = "activityId=" + activityId;
    var pages = "pages/index/index?inviteId=" + inviteId + "&handlerName=" + (handlerName || '');
    var callbackUrl = vipCallBackUrl + "&query=" + encodeURIComponent(query) + "&page=" + encodeURIComponent(pages);
    return callbackUrl;
};
//# sourceMappingURL=vip.js.map