"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendEname = exports.sendCredits = exports.sendTBAward = void 0;
var constants_1 = require("../../constants");
var sdk_1 = require("../../sdk");
/**
 * 发奖，包含权益，实物，积分
 * @param {*} document 必须要有{ type, ename, _id }
 * @param {*} session
 * @param {*} context
 */
exports.sendTBAward = function (context, session, document) { return __awaiter(void 0, void 0, void 0, function () {
    var type, ename, _id, credits, _a, drawStatus, remark, _b, drawStatus, remark, e_1;
    return __generator(this, function (_c) {
        switch (_c.label) {
            case 0:
                type = document.type, ename = document.ename, _id = document._id, credits = document.credits;
                if (!type) {
                    return [2 /*return*/, constants_1.CODE_TYPES.PARAMS_ERROR];
                }
                if (type === constants_1.PRIZE_TYPE.OBJECT) {
                    return [2 /*return*/, document];
                }
                _c.label = 1;
            case 1:
                _c.trys.push([1, 6, , 7]);
                console.log("type", type);
                if (!(type === constants_1.PRIZE_TYPE.ENAME)) return [3 /*break*/, 3];
                console.log("\u4E2D\u6743\u76CA");
                return [4 /*yield*/, exports.sendEname(ename, _id, session, context)];
            case 2:
                _a = _c.sent(), drawStatus = _a.drawStatus, remark = _a.remark;
                console.log("drawStatus, remark", drawStatus, remark);
                document.drawStatus = drawStatus;
                document.remark = remark;
                return [3 /*break*/, 5];
            case 3:
                if (!(type === constants_1.PRIZE_TYPE.CREDITS)) return [3 /*break*/, 5];
                return [4 /*yield*/, exports.sendCredits(credits, session, context)];
            case 4:
                _b = _c.sent(), drawStatus = _b.drawStatus, remark = _b.remark;
                document.drawStatus = drawStatus;
                document.remark = remark;
                _c.label = 5;
            case 5: return [2 /*return*/, document];
            case 6:
                e_1 = _c.sent();
                console.log("\u53D1\u5956\u9519\u8BEF", e_1);
                return [2 /*return*/, constants_1.CODE_TYPES.PARAMS_ERROR];
            case 7: return [2 /*return*/];
        }
    });
}); };
/**
 * 发放积分
 * @param {发放的积分数} credits
 * @param {*} session
 * @param {*} context
 * @returns {drawStatus, remark}
 */
exports.sendCredits = function (credits, session, context) { return __awaiter(void 0, void 0, void 0, function () {
    var drawStatus, remark, result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                drawStatus = 0;
                remark = '';
                return [4 /*yield*/, sdk_1.TBAPIS.changeCredits(context, session, {
                        quantity: credits,
                        change_type: 2,
                        opt_type: '0',
                        remark: "\u53C2\u4E0E\u6D3B\u52A8\u52A0\u79EF\u5206"
                    })];
            case 1:
                result = _a.sent();
                if (result) {
                    drawStatus = constants_1.DRAW_STATUS.SUCCESS;
                }
                else {
                    drawStatus = constants_1.DRAW_STATUS.FAIL;
                    remark = result.result_msg;
                }
                return [2 /*return*/, { drawStatus: drawStatus, remark: remark }];
        }
    });
}); };
/**
 * @desc 发放权益
 * @param {权益名称} ename
 * @param {唯一key} uniqueId
 * @param {*} session
 * @param {*} context
 * @returns { drawStatus, remark }
 */
exports.sendEname = function (ename, uniqueId, session, context) { return __awaiter(void 0, void 0, void 0, function () {
    var result, e_2, drawStatus, remark, result_code;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                result = {
                    result_success: '',
                    result_code: '',
                    msg: '',
                    result_msg: '',
                    sub_msg: ''
                };
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4 /*yield*/, sdk_1.TBAPIS.benefitSend(context, {
                        right_ename: ename,
                        receiver_id: context.openId,
                        unique_id: uniqueId,
                        app_name: constants_1.C_APP_NAME,
                        session: session
                    })];
            case 2:
                result = _a.sent();
                return [3 /*break*/, 4];
            case 3:
                e_2 = _a.sent();
                console.log("\u53D1\u653E\u6743\u76CA\u5931\u8D25", e_2);
                result = e_2;
                return [3 /*break*/, 4];
            case 4:
                drawStatus = 0;
                remark = '';
                if (result.result_success) {
                    drawStatus = constants_1.DRAW_STATUS.SUCCESS;
                }
                else {
                    result_code = result.result_code;
                    if ([
                        'APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT',
                        'APPLY_ONE_SELLER_COUNT_EXCEED_LIMIT',
                        'USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY'
                    ].includes(result_code)) {
                        drawStatus = constants_1.DRAW_STATUS.RETRY;
                    }
                    else {
                        drawStatus = constants_1.DRAW_STATUS.FAIL;
                    }
                    remark = constants_1.TBERROR[result_code || result.msg] || result.result_msg || result.sub_msg || "\u53D1\u653E\u5931\u8D25";
                }
                return [2 /*return*/, { remark: remark, drawStatus: drawStatus }];
        }
    });
}); };
//# sourceMappingURL=sendTBAward.js.map