"use strict";
/** @format */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatVipCbUrl = exports.isUseVipMock = void 0;
var index_1 = require("../../config/index");
/** @format */
// 测试环境 duib2账户mock数据
exports.isUseVipMock = function (context, userNick) {
    var isTestEnv = context.env === 'test';
    var isDuibaAccount = userNick.startsWith('duiba2');
    return isTestEnv && isDuibaAccount;
};
// 格式化Vip回调地址
exports.formatVipCbUrl = function (context) {
    var _a = context.data, activityId = _a.activityId, _b = _a.inviteId, inviteId = _b === void 0 ? '' : _b;
    var vipCallBackUrl = index_1.getConfig(context).vipCallBackUrl;
    // 拼接回调参数
    var query = "activityId=" + activityId + "&inviteId=" + inviteId;
    var callbackUrl = vipCallBackUrl + "&query=" + encodeURIComponent(query);
    return callbackUrl;
};
//# sourceMappingURL=isUseVipMock.js.map