"use strict";
/**
 * 用户相关方法
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../sdk");
var base_service_1 = require("./base.service");
var db_1 = require("../db");
var utils_1 = require("../utils");
var userUpdate_1 = require("../utils/package/userUpdate");
var format_1 = require("../utils/package/format");
var UserService = /** @class */ (function (_super) {
    __extends(UserService, _super);
    function UserService(context) {
        var _this = _super.call(this, context) || this;
        _this.userdao = new sdk_1.BaseDao(context, db_1.USER_DB_NAME);
        return _this;
    }
    /**
     * @desc 获取当前打开活动的用户详情
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    UserService.prototype.getUserInfo = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, openId, data, activityId, record;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.context, openId = _a.openId, data = _a.data;
                        activityId = data.activityId;
                        return [4 /*yield*/, this.userdao.findOne({ openId: openId, activityId: activityId })];
                    case 1:
                        record = _b.sent();
                        return [2 /*return*/, record];
                }
            });
        });
    };
    /**
     * @desc 根据openId获取用户详情
     * @desc 常用于助力分享码为用户openId, 被邀请人打开活动助力时需要获取邀请人的用户详情
     * @param {openId} openId
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    UserService.prototype.getUserInfoByOpenId = function (openId) {
        return __awaiter(this, void 0, void 0, function () {
            var activityId, record;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.userdao.findOne({ openId: openId, activityId: activityId })];
                    case 1:
                        record = _a.sent();
                        return [2 /*return*/, record];
                }
            });
        });
    };
    /**
     * 初始化用户数据
     *
     * @param {IVipInfo} vipInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof UserService
     */
    UserService.prototype.initUserData = function (vipInfo, activityInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, openId, data, activityId, isFollow, avatar, inviteId, userNick, today, tasks, follow, member, user;
            var _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _a = this.context, openId = _a.openId, data = _a.data;
                        activityId = data.activityId, isFollow = data.isFollow, avatar = data.avatar, inviteId = data.inviteId, userNick = data.userNick;
                        today = utils_1.getToday();
                        console.log("----------" + today + "----------", today);
                        tasks = activityInfo.tasks;
                        follow = tasks.follow, member = tasks.member;
                        user = {
                            activityId: activityId,
                            avatar: avatar,
                            inviteId: inviteId,
                            userNick: userNick,
                            openId: openId,
                            // 待领取次数初始化, 根据需自定义添加
                            remainTimes: {
                                follow: isFollow ? follow.value : 0,
                                member: vipInfo.isVip ? member.value : 0
                            },
                            member: {
                                flag: !!vipInfo.isVip
                            },
                            follow: {
                                flag: !!isFollow
                            },
                            login: (_b = {},
                                _b[today] = 1,
                                _b),
                            taskInfo: (_c = {},
                                _c[today] = {},
                                _c),
                            createTime: Date.now(),
                            createDay: today,
                            updateTime: Date.now()
                        };
                        // 初始化 如果已关注添加任务记录
                        if (isFollow) {
                            user.taskInfo[today].follow = [{ createTime: Date.now() }];
                        }
                        // 初始化 如果已经是会员添加任务记录
                        if (vipInfo.isVip) {
                            user.taskInfo[today].member = [{ createTime: Date.now() }];
                        }
                        return [4 /*yield*/, this.userdao.insertOne(user)];
                    case 1:
                        _d.sent();
                        return [2 /*return*/, user];
                }
            });
        });
    };
    UserService.prototype.updateUserData = function (vipInfo, userInfo, activityInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var data, isFollow, today, projection, tasks, follow, member, followBefore, followNow, isNewVip;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        data = this.context.data;
                        isFollow = data.isFollow;
                        today = utils_1.getToday();
                        projection = {
                            $set: {
                                updateTime: Date.now()
                            },
                            $push: {},
                            $inc: (_a = {},
                                _a["login." + today] = 1,
                                _a)
                        };
                        tasks = activityInfo.tasks;
                        follow = tasks.follow, member = tasks.member;
                        followBefore = userInfo.follow.flag;
                        followNow = isFollow;
                        if (!followBefore && followNow && !userInfo.follow.newFollow) {
                            // @ts-ignore
                            projection.$set.follow = this.setNewFollowUserData(userInfo.follow);
                            projection.$push["taskInfo." + today + ".follow"] = { createTime: Date.now() };
                            projection.$inc["remainTimes.follow"] = follow.value;
                        }
                        isNewVip = userUpdate_1.checkNewVip(userInfo, vipInfo);
                        if (isNewVip && !userInfo.member.newMember) {
                            // @ts-ignore
                            projection.$set.member = this.setNewVipUserData(userInfo.member);
                            projection.$push["taskInfo." + today + ".member"] = { createTime: Date.now() };
                            projection.$inc["remainTimes.member"] = member.value;
                        }
                        return [4 /*yield*/, this.updateUser(userInfo._id, projection)];
                    case 1:
                        _b.sent();
                        return [2 /*return*/, __assign(__assign({}, userInfo), { 
                                // @ts-ignore
                                follow: projection.$set.follow || userInfo.follow, 
                                // @ts-ignore
                                member: projection.$set.member || userInfo.member })];
                }
            });
        });
    };
    /**
     * @desc 更新用户表
     * @param {用户的主键id} _id
     * @param {更新的对象} document
     * @returns 若更新成功，返回为1； 若更新失败，返回为 0 或系统直接报错
     */
    UserService.prototype.updateUser = function (_id, projection) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.userdao.update({ _id: _id }, utils_1.formatUpdateUserProjection(projection))];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    // 获取排名列表
    UserService.prototype.getRank = function (sortValueKey, sortTimeKey, limit) {
        if (limit === void 0) { limit = 200; }
        return __awaiter(this, void 0, void 0, function () {
            var activityId, list;
            var _a, _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.userdao.find((_a = {
                                    activityId: activityId
                                },
                                _a[sortValueKey] = { $gt: 0 },
                                _a), {
                                projection: (_b = {}, _b[sortValueKey] = 1, _b.userNick = 1, _b.avatar = 1, _b._id = 0, _b),
                                sort: (_c = {}, _c[sortValueKey] = -1, _c[sortTimeKey] = 1, _c),
                                limit: limit
                            })];
                    case 1:
                        list = _d.sent();
                        return [2 /*return*/, list.map(function (v, i) {
                                return __assign(__assign({}, v), { userNick: format_1.formatUserNick(v.userNick), rank: i + 1 });
                            })];
                }
            });
        });
    };
    /**
     *  获取用户排名
     *
     * @param {string} sortValueKey 排名字段
     * @param {number} userValue
     * @param {string} sortTimeKey
     * @return {number}  排行
     * @memberof UserService
     */
    UserService.prototype.getMyRank = function (sortValueKey, sortTimeKey, userValue) {
        return __awaiter(this, void 0, void 0, function () {
            var activityId, openId, sameScoreList, rank, gap, j;
            var _a, _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        openId = this.context.openId;
                        return [4 /*yield*/, this.userdao.find((_a = {}, _a[sortValueKey] = userValue, _a.activityId = activityId, _a), {
                                sort: (_b = {}, _b[sortTimeKey] = 1, _b)
                            })];
                    case 1:
                        sameScoreList = _d.sent();
                        gap = 0;
                        //说明有多个跟自己同分数的人
                        for (j = 0; j < sameScoreList.length; j++) {
                            if (sameScoreList[j].openId === openId) {
                                gap = j;
                            }
                        }
                        return [4 /*yield*/, this.userdao.count((_c = {}, _c[sortValueKey] = { $gt: userValue }, _c.activityId = activityId, _c))];
                    case 2:
                        rank = _d.sent();
                        rank = rank + 1 + gap;
                        return [2 /*return*/, rank];
                }
            });
        });
    };
    /**
     * @desc 根据用户主键id查找用户详情
     * @param {用户的主键id} _id
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    UserService.prototype.getUserInfoById = function (_id) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.userdao.findOne({ _id: _id })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    return UserService;
}(base_service_1.default));
exports.default = UserService;
//# sourceMappingURL=user.service.js.map