/**
 * 用户相关方法
 *
 * @format
 */
import BaseService from './base.service';
declare class UserService extends BaseService {
    userdao: IBaseDao;
    constructor(context: IContext<IParams>);
    /**
     * @desc 获取当前打开活动的用户详情
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    getUserInfo(): Promise<IUserInfo>;
    /**
     * @desc 根据openId获取用户详情
     * @desc 常用于助力分享码为用户openId, 被邀请人打开活动助力时需要获取邀请人的用户详情
     * @param {openId} openId
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    getUserInfoByOpenId(openId: string): Promise<IUserInfo>;
    /**
     * 初始化用户数据
     *
     * @param {IVipInfo} vipInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof UserService
     */
    initUserData(vipInfo: IVipInfo, activityInfo: IActivityInfo): Promise<IUserInfo>;
    updateUserData(vipInfo: IVipInfo, userInfo: IUserInfo, activityInfo: IActivityInfo): Promise<IUserInfo>;
    /**
     * @desc 更新用户表
     * @param {用户的主键id} _id
     * @param {更新的对象} document
     * @returns 若更新成功，返回为1； 若更新失败，返回为 0 或系统直接报错
     */
    updateUser(_id: string, projection: IUpdateQuery): Promise<number>;
    getRank(sortValueKey: string, sortTimeKey: string, limit?: number): Promise<{
        userNick: string;
        rank: number;
        _id?: string;
        id?: string;
        activityId: string;
        avatar: string;
        openId: string;
        createTime: number;
        updateTime: number;
        createDay?: string;
        inviteId?: string;
        member?: IMemberInfo;
        follow?: IFollowInfo;
        remainTimes?: IRemainTimesInfo;
        taskInfo?: object;
        login?: object;
    }[]>;
    /**
     *  获取用户排名
     *
     * @param {string} sortValueKey 排名字段
     * @param {number} userValue
     * @param {string} sortTimeKey
     * @return {number}  排行
     * @memberof UserService
     */
    getMyRank(sortValueKey: string, sortTimeKey: string, userValue: number): Promise<number>;
    /**
     * @desc 根据用户主键id查找用户详情
     * @param {用户的主键id} _id
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    getUserInfoById(_id: string): Promise<unknown>;
}
export default UserService;
