"use strict";
/**
 * 任务相关方法
 *
 * @format
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = require("lodash");
var user_service_1 = require("./user.service");
var utils_1 = require("../utils");
var constants_1 = require("../constants");
var TaskService = /** @class */ (function (_super) {
    __extends(TaskService, _super);
    function TaskService(context) {
        return _super.call(this, context) || this;
    }
    /**
     *  根据任务类型初始化   b端 tasks字段必须有相应的配置
     *
     * @param {ITaskType} taskType 任务类型
     * @param {string} title 任务标题
     * @param {ITasks} tasks 任务配置
     * @param {IUserInfo} userInfo 用户信息
     * @return {ITaskInfo}  {ITaskInfo} 任务信息
     * @memberof TaskService
     */
    TaskService.prototype.initTask = function (taskType, title, tasks, userInfo) {
        var _a = tasks, _b = taskType, _c = _a[_b], value = _c.value, _d = _c.itemIds, itemIds = _d === void 0 ? '' : _d, taskRateType = _c.taskRateType, _e = _c.times, times = _e === void 0 ? 1 : _e, _f = _c.link, link = _f === void 0 ? '' : _f;
        var remainTimes = userInfo.remainTimes;
        var todayCompleteTimes = this.getTodayCompleteTask(taskType, userInfo).todayCompleteTimes;
        var completeTimes = this.getCompleteTaskByUserTaskInfo(taskType, userInfo).completeTimes;
        return {
            taskType: taskType,
            title: title,
            itemIds: itemIds,
            rewards: value,
            taskRateType: taskRateType,
            times: times,
            url: taskType === 'member' ? utils_1.generateVipUrl(utils_1.formatVipCbUrl(this.context)) : link,
            todayCompleteTimes: todayCompleteTimes,
            completeTimes: completeTimes,
            status: this.setTaskStatus(userInfo, taskType, taskRateType, times),
            waitReceive: remainTimes[taskType]
        };
    };
    // 根据会员状态更新
    TaskService.prototype.updateVipTask = function (userInfo, vipInfo, tasks) {
        var member = userInfo.member;
        var newMember = member.newMember;
        var today = utils_1.getToday();
        var isNewVip = utils_1.checkNewVip(userInfo, vipInfo);
        var value = tasks.member.value;
        var projection = {
            $set: {},
            $inc: {},
            $push: {}
        };
        if (isNewVip && !newMember) {
            member = utils_1.setNewVipUserData(member);
            // @ts-ignore
            projection.$set.member = member;
            projection.$inc['remainTimes.member'] = +value;
            projection.$push["taskInfo." + today + ".member"] = {
                creatTime: Date.now()
            };
        }
        return projection;
    };
    // 根据下单下单记录,更新状态
    TaskService.prototype.updateOrderGoodsTask = function (userInfo, tasks, activityStartTime, session) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            var taskType, _c, _d, _e, value, itemIds, taskRateType, times, _f, completeTimes, taskInfo, todayCompleteTimes, today, orderResult, itemIdsArr, projection, targetOrders;
            var _g;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        taskType = 'orderGoods';
                        _c = tasks, _d = taskType, _e = _c[_d], value = _e.value, itemIds = _e.itemIds, taskRateType = _e.taskRateType, times = _e.times;
                        _f = this.getCompleteTaskByUserTaskInfo(taskType, userInfo), completeTimes = _f.completeTimes, taskInfo = _f.taskInfo;
                        todayCompleteTimes = this.getTodayCompleteTask(taskType, userInfo).todayCompleteTimes;
                        // 永久任务且已完成
                        if (taskRateType === constants_1.TASK_RATE_TYPE.FOREVER && completeTimes) {
                            return [2 /*return*/, {}];
                        }
                        today = utils_1.getToday();
                        if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && todayCompleteTimes >= times) {
                            return [2 /*return*/, {}];
                        }
                        return [4 /*yield*/, utils_1.getUserOrderlist(this.context, 
                            //@ts-ignore
                            activityStartTime || Date.now(), Date.now(), session)];
                    case 1:
                        orderResult = _h.sent();
                        itemIdsArr = itemIds.split(',').map(function (v) { return +v; });
                        projection = {
                            $inc: (_g = {},
                                _g["remainTimes." + taskType] = 0,
                                _g),
                            $set: {}
                        };
                        targetOrders = ((_b = (_a = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _a === void 0 ? void 0 : _a[today]) === null || _b === void 0 ? void 0 : _b[taskType]) || [];
                        orderResult.forEach(function (v) {
                            // @ts-ignore
                            // 商品订单包含目标商品 且orderId为新订单
                            if (itemIdsArr.includes(v.itemId) && !taskInfo.some(function (order) { return order.orderId === v.orderId; })) {
                                if (taskRateType === constants_1.TASK_RATE_TYPE.EVERYDAY && targetOrders.length >= times) {
                                    return;
                                }
                                projection.$inc["remainTimes." + taskType] += +value;
                                targetOrders.push({
                                    itemId: v.itemId,
                                    orderId: v.orderId,
                                    payTime: v.payTime,
                                    createTime: Date.now()
                                });
                            }
                            if (targetOrders === null || targetOrders === void 0 ? void 0 : targetOrders.length) {
                                projection.$set["taskInfo." + today + "." + taskType] = targetOrders;
                            }
                        });
                        return [2 /*return*/, projection];
                }
            });
        });
    };
    // 更新签到任务数据
    TaskService.prototype.updateSignTask = function (userInfo, tasks) {
        var _a;
        // 获取签到奖励
        var value = (tasks || {}).sign.value;
        var todayCompleteTimes = this.getTodayCompleteTask('sign', userInfo).todayCompleteTimes;
        var today = utils_1.getToday();
        // 今天没有有完成记录
        return todayCompleteTimes === 0
            ? {
                $inc: {
                    'remainTimes.sign': value
                },
                $push: (_a = {},
                    _a["taskInfo." + today + ".sign"] = { createTime: Date.now() },
                    _a)
            }
            : {};
    };
    /**
     *更新关注店铺任务状态
     *
     * @param {IUserInfo} userInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof TaskService
     */
    TaskService.prototype.updateFollowTask = function (userInfo, activityInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var today, _id, follow, tasks, value, followInfo;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        today = utils_1.getToday();
                        _id = userInfo._id, follow = userInfo.follow;
                        tasks = activityInfo.tasks;
                        value = (tasks || {}).follow.value;
                        followInfo = utils_1.setNewFollowUserData(follow);
                        return [4 /*yield*/, this.updateUser(_id, {
                                $set: {
                                    follow: followInfo
                                },
                                $inc: {
                                    'remainTimes.follow': value
                                },
                                $push: (_a = {},
                                    _a["taskInfo." + today + ".follow"] = {
                                        creatTime: Date.now()
                                    },
                                    _a)
                            })];
                    case 1: 
                    // 增加待领取次数
                    return [2 /*return*/, _b.sent()];
                }
            });
        });
    };
    /**
     *
     *  根据用户和任务完成情况,设置任务状态
     *
     * @param {IUserInfo} useInfo
     * @param {string} taskType
     * @param {number} taskRateType
     * @param {number} [limitTimesEverday] 每天限制次数 任务频率为每天的时候必填
     * @return {taskTatus} 1未完成 2 待领取 3 已完成
     * @memberof TaskService
     */
    TaskService.prototype.setTaskStatus = function (useInfo, taskType, taskRateType, limitTimesEveryday) {
        var _a;
        if (limitTimesEveryday === void 0) { limitTimesEveryday = 1; }
        var waitReceive = ((_a = useInfo === null || useInfo === void 0 ? void 0 : useInfo.remainTimes) === null || _a === void 0 ? void 0 : _a[taskType]) || 0;
        if (waitReceive)
            return constants_1.TASK_STATUS.WAIT_RECEIVE;
        // 当天的完成次数
        var todayCompleteTimes = this.getTodayCompleteTask(taskType, useInfo).todayCompleteTimes;
        // 总共的完成次数
        var completeTimes = this.getCompleteTaskByUserTaskInfo(taskType, useInfo).completeTimes;
        switch (taskRateType) {
            case constants_1.TASK_RATE_TYPE.FOREVER:
                return completeTimes > 0 ? constants_1.TASK_STATUS.DONE : constants_1.TASK_STATUS.WAIT_DO;
                break;
            case constants_1.TASK_RATE_TYPE.EVERYDAY:
                return todayCompleteTimes >= limitTimesEveryday ? constants_1.TASK_STATUS.DONE : constants_1.TASK_STATUS.WAIT_DO;
                break;
            case constants_1.TASK_RATE_TYPE.NOLIMIT:
                return constants_1.TASK_STATUS.WAIT_DO;
                break;
        }
    };
    /**
     *
     * 获取任务今天完成的次数
     *
     * @param {string} taskType  任务类型
     * @param {IUserInfo} userInfo 用户信息
     * @returns {number} todayTimes  今日任务完成次数  todayTaskInfo  今日对应任务完成详情
     * @memberof TaskService
     */
    TaskService.prototype.getTodayCompleteTask = function (taskType, userInfo) {
        var _a, _b, _c, _d, _e;
        var today = utils_1.getToday();
        return {
            todayCompleteTimes: ((_c = (_b = (_a = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _a === void 0 ? void 0 : _a[today]) === null || _b === void 0 ? void 0 : _b[taskType]) === null || _c === void 0 ? void 0 : _c.length) || 0,
            todayTaskInfo: ((_e = (_d = userInfo === null || userInfo === void 0 ? void 0 : userInfo.taskInfo) === null || _d === void 0 ? void 0 : _d[today]) === null || _e === void 0 ? void 0 : _e[taskType]) || []
        };
    };
    /**
     * 根据任务类型获取任务完成情况
     *
     * @param {IUserInfo} userInfo
     * @param {string} taskType
     * @returns {array}
     * @memberof TaskService
     */
    TaskService.prototype.getCompleteTaskByUserTaskInfo = function (taskType, userInfo) {
        var _a = userInfo.taskInfo, taskInfo = _a === void 0 ? {} : _a;
        var targetTaskList = [];
        Object.keys(taskInfo).forEach(function (day) {
            var _a, _b, _c, _d;
            if ((_a = taskInfo[day]) === null || _a === void 0 ? void 0 : _a[taskType]) {
                var dayTaskInfo = Array.isArray((_b = taskInfo[day]) === null || _b === void 0 ? void 0 : _b[taskType])
                    ? (_c = taskInfo[day]) === null || _c === void 0 ? void 0 : _c[taskType] : [(_d = taskInfo[day]) === null || _d === void 0 ? void 0 : _d[taskType]];
                targetTaskList = __spreadArrays(targetTaskList, dayTaskInfo);
            }
        });
        return {
            completeTimes: (targetTaskList === null || targetTaskList === void 0 ? void 0 : targetTaskList.length) || 0,
            taskInfo: targetTaskList
        };
    };
    /**
     *根据任务类型更新任务待领取次数和任务记录
     *
     * @param {string} taskType
     * @param {number} rewards
     * @param {IUserInfo} userInfo
     * @param {object} [customRecord]
     * @returns {boolean}
     * @memberof TaskService
     */
    TaskService.prototype.updateUserTaskRecord = function (taskType, rewards, userInfo, customRecord) {
        return __awaiter(this, void 0, void 0, function () {
            var _id, today, result;
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _id = userInfo._id;
                        today = utils_1.getToday();
                        return [4 /*yield*/, this.updateUser(_id, {
                                $inc: (_a = {},
                                    _a["remainTimes." + taskType] = rewards,
                                    _a),
                                $push: (_b = {},
                                    _b["taskInfo." + today + "." + taskType] = __assign({ createTime: Date.now() }, customRecord),
                                    _b)
                            })];
                    case 1:
                        result = _c.sent();
                        return [2 /*return*/, result === 1];
                }
            });
        });
    };
    /**
     *
     *  更新user表中,任务相关字段
     *
     * @param {string} id
     * @param {object[]} needUpdateKeysArray
     * @param {IUserInfo} userInfo
     * @returns {IUserInfo | boolean} userInfo
     * @memberof TaskService
     */
    TaskService.prototype.updateTasks = function (id, needUpdateKeysArray, userInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var updateKeys, _$inc, _$set, _$push;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        utils_1.logger(needUpdateKeysArray);
                        updateKeys = lodash_1.merge.apply(void 0, __spreadArrays([{}], needUpdateKeysArray));
                        utils_1.logger(updateKeys);
                        _$inc = updateKeys.$inc || {};
                        _$set = updateKeys.$set || {};
                        _$push = updateKeys.$push || {};
                        // 删除空的操作
                        if (!Object.keys(_$inc).length && updateKeys.$inc) {
                            delete updateKeys.$inc;
                        }
                        if (!Object.keys(_$set).length && updateKeys.$set) {
                            delete updateKeys.$set;
                        }
                        if (!Object.keys(_$push).length && updateKeys.$push) {
                            delete updateKeys.$push;
                        }
                        if (!Object.keys(updateKeys).length) {
                            return [2 /*return*/, userInfo];
                        }
                        return [4 /*yield*/, this.updateUser(id, updateKeys)
                            // 更新数据库后 延迟10ms 执行
                        ];
                    case 1:
                        _a.sent();
                        // 更新数据库后 延迟10ms 执行
                        return [4 /*yield*/, utils_1.sleep(10)];
                    case 2:
                        // 更新数据库后 延迟10ms 执行
                        _a.sent();
                        return [4 /*yield*/, this.getUserInfo()];
                    case 3: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    return TaskService;
}(user_service_1.default));
exports.default = TaskService;
//# sourceMappingURL=task.service.js.map