/**
 * 任务相关方法
 *
 * @format
 */
import UserService from './user.service';
export interface ITaskInfo {
    taskType?: string;
    url?: string;
    rewards: number;
    itemIds?: string;
    todayCompleteTimes?: number;
    completeTimes?: number;
    taskRateType: number;
    times?: number;
    waitReceive?: number;
    title: string;
    status: number;
}
export default class TaskService extends UserService {
    constructor(context: IContext<IParams>);
    /**
     *  根据任务类型初始化   b端 tasks字段必须有相应的配置
     *
     * @param {ITaskType} taskType 任务类型
     * @param {string} title 任务标题
     * @param {ITasks} tasks 任务配置
     * @param {IUserInfo} userInfo 用户信息
     * @return {ITaskInfo}  {ITaskInfo} 任务信息
     * @memberof TaskService
     */
    initTask(taskType: ITaskType, title: string, tasks: ITasks, userInfo: IUserInfo): ITaskInfo;
    updateVipTask(userInfo: IUserInfo, vipInfo: IVipInfo, tasks: ITasks): {
        $set: {};
        $inc: {};
        $push: {};
    };
    updateOrderGoodsTask(userInfo: IUserInfo, tasks: ITasks, activityStartTime: number, session?: string): Promise<{}>;
    updateSignTask(userInfo: IUserInfo, tasks: ITasks): {
        $inc: {
            'remainTimes.sign': number;
        };
        $push: {
            [x: string]: {
                createTime: number;
            };
        };
    } | {
        $inc?: undefined;
        $push?: undefined;
    };
    /**
     *更新关注店铺任务状态
     *
     * @param {IUserInfo} userInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof TaskService
     */
    updateFollowTask(userInfo: IUserInfo, activityInfo: IActivityInfo): Promise<number>;
    /**
     *
     *  根据用户和任务完成情况,设置任务状态
     *
     * @param {IUserInfo} useInfo
     * @param {string} taskType
     * @param {number} taskRateType
     * @param {number} [limitTimesEverday] 每天限制次数 任务频率为每天的时候必填
     * @return {taskTatus} 1未完成 2 待领取 3 已完成
     * @memberof TaskService
     */
    setTaskStatus(useInfo: IUserInfo, taskType: string, taskRateType: number, limitTimesEveryday?: number): number;
    /**
     *
     * 获取任务今天完成的次数
     *
     * @param {string} taskType  任务类型
     * @param {IUserInfo} userInfo 用户信息
     * @returns {number} todayTimes  今日任务完成次数  todayTaskInfo  今日对应任务完成详情
     * @memberof TaskService
     */
    getTodayCompleteTask(taskType: string, userInfo: IUserInfo): {
        todayCompleteTimes: number;
        todayTaskInfo: ITaskDetail[];
    };
    /**
     * 根据任务类型获取任务完成情况
     *
     * @param {IUserInfo} userInfo
     * @param {string} taskType
     * @returns {array}
     * @memberof TaskService
     */
    getCompleteTaskByUserTaskInfo(taskType: string, userInfo: IUserInfo): {
        completeTimes: number;
        taskInfo: ITaskDetail[];
    };
    /**
     *根据任务类型更新任务待领取次数和任务记录
     *
     * @param {string} taskType
     * @param {number} rewards
     * @param {IUserInfo} userInfo
     * @param {object} [customRecord]
     * @returns {boolean}
     * @memberof TaskService
     */
    updateUserTaskRecord(taskType: string, rewards: number, userInfo: IUserInfo, customRecord?: object): Promise<boolean>;
    /**
     *
     *  更新user表中,任务相关字段
     *
     * @param {string} id
     * @param {object[]} needUpdateKeysArray
     * @param {IUserInfo} userInfo
     * @returns {IUserInfo | boolean} userInfo
     * @memberof TaskService
     */
    updateTasks(id: string, needUpdateKeysArray: object[], userInfo: IUserInfo): Promise<false | IUserInfo>;
}
