"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var utils_1 = require("../utils");
var user_service_1 = require("./user.service");
var sdk_1 = require("../sdk");
var db_1 = require("../db");
var RecordService = /** @class */ (function (_super) {
    __extends(RecordService, _super);
    function RecordService(context) {
        var _this = _super.call(this, context) || this;
        _this.recorddao = new sdk_1.BaseDao(context, db_1.RECORD_DB_NAME);
        return _this;
    }
    // 添加受邀记录
    RecordService.prototype.addReceiveShareRecord = function () {
        return __awaiter(this, void 0, void 0, function () {
            var inviteId, record;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        inviteId = this.context.data.inviteId;
                        return [4 /*yield*/, this.initRecordData({
                                recordType: constants_1.RECORD_TYPE.RECIEVE_SHARE
                            }, {
                                inviteId: inviteId
                            })];
                    case 1:
                        record = _a.sent();
                        return [4 /*yield*/, this.recorddao.insertOne(record)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.getGamePrizeRecordDetail = function () {
        return __awaiter(this, void 0, void 0, function () {
            var openId, activityId;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        openId = this.context.openId;
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.recorddao.find({
                                recordType: constants_1.RECORD_TYPE.GAME_PRIZE.type,
                                activityId: activityId,
                                openId: openId
                            })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.addDoLikeRecord = function () {
        return __awaiter(this, void 0, void 0, function () {
            var inviteId, record;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        inviteId = this.context.data.inviteId;
                        return [4 /*yield*/, this.initRecordData({
                                recordType: constants_1.RECORD_TYPE.DO_LIKE
                            }, {
                                inviteId: inviteId
                            })];
                    case 1:
                        record = _a.sent();
                        return [4 /*yield*/, this.recorddao.insertOne(record)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.addRecord = function (recordType, customData) {
        return __awaiter(this, void 0, void 0, function () {
            var record;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.initRecordData({
                            recordType: recordType
                        }, __assign({}, customData))];
                    case 1:
                        record = _a.sent();
                        return [4 /*yield*/, this.recorddao.insertOne(record)];
                    case 2: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.getLikeTotal = function () {
        return __awaiter(this, void 0, void 0, function () {
            var activityId;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.recorddao.count({
                                recordType: constants_1.RECORD_TYPE.DO_LIKE.type,
                                activityId: activityId
                            })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.getLikeByDay = function (createDay) {
        return __awaiter(this, void 0, void 0, function () {
            var activityId;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.recorddao.count({
                                recordType: constants_1.RECORD_TYPE.DO_LIKE.type,
                                createDay: createDay,
                                activityId: activityId
                            })];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.getRecordCountByType = function (recordType, openId, customData) {
        if (customData === void 0) { customData = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var activityId;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        activityId = this.context.data.activityId;
                        return [4 /*yield*/, this.recorddao.count(__assign({ recordType: recordType,
                                openId: openId,
                                activityId: activityId }, customData))];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    RecordService.prototype.initRecordData = function (_a, customData) {
        var recordType = _a.recordType;
        if (customData === void 0) { customData = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var _b, openId, data, activityId, userNick, userInfo, record;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _b = this.context, openId = _b.openId, data = _b.data;
                        activityId = data.activityId, userNick = data.userNick;
                        if (!!userNick) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.getUserInfo()];
                    case 1:
                        userInfo = _c.sent();
                        if (userInfo) {
                            userNick = userInfo.userNick;
                        }
                        _c.label = 2;
                    case 2:
                        record = __assign({ openId: openId,
                            activityId: activityId,
                            userNick: userNick, recordType: recordType.type, recordName: recordType.name, createTime: Date.now(), createDay: utils_1.getToday() }, customData);
                        return [2 /*return*/, record];
                }
            });
        });
    };
    return RecordService;
}(user_service_1.default));
exports.default = RecordService;
//# sourceMappingURL=record.service.js.map