/**
 * 基本信息
 *
 * @format
 */
export default class BaseService {
    context: IContext<any>;
    activitydao: IBaseDao;
    constructor(context: IContext<any>);
    /**
     * @desc 活动基本信息
     * @param {活动id} activityId
     * @returns 返回活动详情，若不存在活动，返回为null
     */
    getBaseInfo(activityId: string): Promise<IActivityInfo>;
    /**
     *
     * 根据itemIds获取商品列表
     *
     * @param {string} itemIds
     * @param {string} session
     * @return {Array}
     * @memberof BaseService
     */
    getItemListByIds(itemIds: string, session: string): Promise<Array<ITaoBaoItems>>;
}
