/**
 * 奖励
 *
 * @format
 */
import UserService from './user.service';
import { CodeType } from 'taobao-mini-sdk/lib/utils/codetypes';
export default class AwardsService extends UserService {
    awardsdao: IBaseDao;
    activityprizedao: IBaseDao;
    constructor(context: IContext<IParams>);
    reduceStock(_id: string): Promise<number | CodeType>;
    /**
     * 插入奖品记录
     * @param {*} award
     */
    addAward(award: IAwards): Promise<string | CodeType>;
    /**
     * 发放奖品
     * @param {*} document
     */
    sendAward(document: IAwards): Promise<CodeType | IAwards>;
    /**
     * 我的奖品
     * @param {*} param0
     */
    getMyPrizeList({ openId, activityId }: {
        openId: string;
        activityId: string;
    }): Promise<Array<IAwards>>;
    recieveObjectPrize(_id: string, { activityId, province, city, area, streetName, addressDetail, name, phone }: {
        activityId: string;
        province: string;
        city: string;
        area: string;
        streetName: string;
        addressDetail: string;
        name: string;
        phone: string | number;
    }): Promise<true | CodeType>;
    recieveEnamePrize(_id: string, activityId: string): Promise<CodeType | IAwards>;
    getPrizeConfig(query: {
        activityId: string;
        [queryParam: string]: any;
    }): Promise<Array<IActivityPrize>>;
    getPrizeByProbability(prizes: Array<IActivityPrize>): Promise<IActivityPrize>;
    /**
     * 获取活动配置项奖品
     * @param {string} _id
     */
    getActivityPrizeById(_id: string): Promise<unknown>;
}
