"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.activityTimeCheck = exports.vipCheck = exports.userCheck = exports.paramsCheck = void 0;
/** @format */
var sdk_1 = require("../sdk");
var constants_1 = require("../constants");
var service_1 = require("../service");
var utils_1 = require("../utils");
var vip_1 = require("../utils/package/vip");
// 检验参数是否存在
exports.paramsCheck = function (params) {
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var context = args[0], _b = args[1], otherArgs = _b === void 0 ? {} : _b;
            var dataKeys = Object.keys(context.data);
            for (var i = 0; i < params.length; i++) {
                var param = params[i];
                if (!dataKeys.includes(param) || ((_a = context.data) === null || _a === void 0 ? void 0 : _a[param]) === '') {
                    utils_1.logFn(context);
                    return sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11" + param + "\u53C2\u6570");
                }
            }
            return method.apply(target, [context, __assign({}, otherArgs)]);
        };
    };
};
// 检验用户是否存在
exports.userCheck = function (_a) {
    var _b = _a.intercept, intercept = _b === void 0 ? true : _b;
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return __awaiter(this, void 0, void 0, function () {
                var context, _a, otherArgs, userService, userInfo;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            context = args[0], _a = args[1], otherArgs = _a === void 0 ? {} : _a;
                            userService = new service_1.UserService(context);
                            return [4 /*yield*/, userService.getUserInfo()];
                        case 1:
                            userInfo = _b.sent();
                            if (!userInfo && intercept)
                                return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_NO_USER)];
                            return [2 /*return*/, method.apply(target, [context, __assign(__assign({}, otherArgs), { userInfo: userInfo })])];
                    }
                });
            });
        };
    };
};
// 是否是会员
exports.vipCheck = function (_a) {
    var _b = _a.intercept, intercept = _b === void 0 ? true : _b;
    return function (target, name, descriptor) {
        var method = descriptor.value;
        descriptor.value = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return __awaiter(this, void 0, void 0, function () {
                var context, _a, otherArgs, userService, _b, session, userNick, vipInfo;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            context = args[0], _a = args[1], otherArgs = _a === void 0 ? {} : _a;
                            userService = new service_1.UserService(context);
                            return [4 /*yield*/, utils_1.getSellerSession(context)];
                        case 1:
                            _b = _c.sent(), session = _b.session, userNick = _b.userNick;
                            return [4 /*yield*/, vip_1.getShopVip(context, session, vip_1.formatVipCbUrl(context), userNick)];
                        case 2:
                            vipInfo = _c.sent();
                            if (!vipInfo.isVip && intercept)
                                return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_NO_VIP, '非店铺会员', vipInfo)];
                            return [2 /*return*/, method.apply(target, [context, __assign(__assign({}, otherArgs), { vipInfo: vipInfo, session: session })])];
                    }
                });
            });
        };
    };
};
// 活动时间校验
exports.activityTimeCheck = function (target, name, descriptor) {
    var method = descriptor.value;
    descriptor.value = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            var context, _a, otherArgs, activityId, baseService, activityInfo, startTime, endTime, currentTime;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        context = args[0], _a = args[1], otherArgs = _a === void 0 ? {} : _a;
                        activityId = context.data.activityId;
                        if (!activityId)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.PARAMS_ERROR, "\u7F3A\u5C11\u6D3B\u52A8id")];
                        baseService = new service_1.BaseService(context);
                        return [4 /*yield*/, baseService.getBaseInfo(activityId)
                            // 活动不存在
                        ];
                    case 1:
                        activityInfo = _b.sent();
                        // 活动不存在
                        if (!activityInfo) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_NO_ACTIVITY)];
                        }
                        startTime = activityInfo.startTime, endTime = activityInfo.endTime;
                        currentTime = Date.now();
                        if (currentTime < startTime) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_ACTIVITY_NOSTART, "\u6D3B\u52A8\u672A\u5F00\u59CB")];
                        }
                        if (currentTime > endTime) {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_ACTIVITY_OVER, "\u6D3B\u52A8\u5DF2\u7ED3\u675F")];
                        }
                        return [2 /*return*/, method.apply(target, [context, __assign(__assign({}, otherArgs), { activityInfo: activityInfo })])];
                }
            });
        });
    };
};
//# sourceMappingURL=check.js.map