"use strict";
/** @format */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var service_1 = require("../service");
var vip_1 = require("../utils/package/vip");
var User = /** @class */ (function () {
    function User() {
    }
    /**
     *  登录接口, 初始化/更新用户信息
     */
    User.prototype.login = function (context, _a, _b) {
        var userInfo = _a.userInfo, vipInfo = _a.vipInfo, activityInfo = _a.activityInfo;
        var userService = _b[0], accessService = _b[1];
        return __awaiter(this, void 0, void 0, function () {
            var openId;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        openId = context.openId;
                        if (!!userInfo) return [3 /*break*/, 2];
                        return [4 /*yield*/, userService.initUserData(vipInfo, activityInfo)];
                    case 1:
                        userInfo = _c.sent();
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, userService.updateUserData(vipInfo, userInfo, activityInfo)];
                    case 3:
                        userInfo = _c.sent();
                        _c.label = 4;
                    case 4: 
                    // access表
                    return [4 /*yield*/, accessService.addAccess(userInfo)];
                    case 5:
                        // access表
                        _c.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success({
                                openId: openId
                            })];
                }
            });
        });
    };
    /**
     *  获取会员信息
     */
    User.prototype.getVipInfo = function (context, _a) {
        var session = _a.session, activityUserNick = _a.activityUserNick;
        return __awaiter(this, void 0, void 0, function () {
            var callbackUrl, result;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        callbackUrl = context.data.callbackUrl;
                        return [4 /*yield*/, vip_1.getShopVip(context, session, callbackUrl || vip_1.formatVipCbUrl(context), activityUserNick)];
                    case 1:
                        result = _b.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(result)];
                }
            });
        });
    };
    /**
     *  获取排行榜
     */
    User.prototype.getRankList = function (context, _a, _b) {
        var userInfo = _a.userInfo;
        var userService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var sortKey, sortTime, userNick, avatar, rank, list;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        sortKey = 'score';
                        sortTime = 'updateScoreTime';
                        userNick = userInfo.userNick, avatar = userInfo.avatar;
                        return [4 /*yield*/, userService.getMyRank(sortKey, sortTime, userInfo[sortKey])];
                    case 1:
                        rank = _c.sent();
                        return [4 /*yield*/, userService.getRank(sortKey, sortTime, 200)];
                    case 2:
                        list = _c.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success({
                                userNick: userNick,
                                avatar: avatar,
                                rank: rank,
                                score: userInfo[sortKey],
                                list: list
                            })];
                }
            });
        });
    };
    __decorate([
        decorator_1.paramsCheck(['activityId', 'userNick', 'avatar', 'isFollow']),
        decorator_1.activityTimeCheck,
        decorator_1.registeInfos(['userInfo', 'vipInfo', 'activityInfo']),
        decorator_1.services([service_1.UserService, service_1.AccessService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], User.prototype, "login", null);
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.registeInfos(['session']),
        decorator_1.services([]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object]),
        __metadata("design:returntype", Promise)
    ], User.prototype, "getVipInfo", null);
    __decorate([
        decorator_1.paramsCheck(['activityId']),
        decorator_1.userCheck({ intercept: true }),
        decorator_1.services([service_1.UserService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], User.prototype, "getRankList", null);
    return User;
}());
exports.default = User;
//# sourceMappingURL=user.controller.js.map