/** @format */
import { UserService, AccessService } from '../service';
export interface IVipParams {
    activityId: string;
    callbackUrl?: string;
    inviteId?: string;
}
export interface ILoginParams {
    activityId: string;
    userNick: string;
    avatar: string;
    isFollow: boolean;
    inviteId?: string;
}
export default class User {
    /**
     *  登录接口, 初始化/更新用户信息
     */
    login(context: IContext<ILoginParams>, { userInfo, vipInfo, activityInfo }: IControllerInfos, [userService, accessService]: [UserService, AccessService]): Promise<IResult<{
        openId: string;
    }>>;
    /**
     *  获取会员信息
     */
    getVipInfo(context: IContext<IVipParams>, { session, activityUserNick }: IControllerInfos): Promise<IResult<IVipInfo>>;
    /**
     *  获取排行榜
     */
    getRankList(context: IContext<{
        activityId: string;
    }>, { userInfo }: IControllerInfos, [userService]: [UserService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        userNick: string;
        avatar: string;
        rank: number;
        score: any;
        list: {
            userNick: string;
            rank: number;
            _id?: string;
            id?: string;
            activityId: string;
            avatar: string;
            openId: string;
            createTime: number;
            updateTime: number;
            createDay?: string;
            inviteId?: string;
            member?: IMemberInfo;
            follow?: IFollowInfo;
            remainTimes?: IRemainTimesInfo;
            taskInfo?: object;
            login?: object;
        }[];
    }, true>>;
}
