/** @format */
import { TaskService, BaseService } from '../service';
import { ITaskInfo } from '../service/task.service';
export default class Task {
    /**
     * 任务列表
     */
    getTaskList(context: IContext<{
        activityId: string;
    }>, { userInfo, vipInfo, activityInfo }: IControllerInfos, [taskService]: [TaskService]): Promise<IResult<ITaskInfo[]>>;
    /**
     *  完成关注店铺任务
     */
    doFollowTask(context: IContext<{
        activityId: string;
    }>, { userInfo, activityInfo }: IControllerInfos, [TaskService]: [TaskService]): Promise<IResult<boolean>>;
    /**
     *  积分兑换次数
     */
    doExchangeCreditsTask(context: IContext<IParams>, { userInfo, activityInfo, session }: IControllerInfos, [taskService]: [TaskService]): Promise<IResult<boolean>>;
    /**
     * 浏览商品
     */
    doBrowseGoodsTask(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [taskService]: [TaskService]): Promise<IResult<boolean>>;
    /**
     * 收藏商品
     */
    doCollectGoodsTask(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [taskService]: [TaskService]): Promise<IResult<boolean>>;
    /**
     * 浏览链接
     */
    doJumpLinkTask(context: IContext<IParams>, { userInfo, activityInfo }: IControllerInfos, [taskService]: [TaskService]): Promise<IResult<boolean>>;
    /**
     * 领取任务奖励
     */
    receiveTaskRewards(context: IContext<IParams>, { userInfo }: IControllerInfos, [taskService]: [TaskService]): Promise<IResult<{
        rewards: number;
    }>>;
    /**
     * 获取收藏商品列表
     */
    getCollectGoodsList(context: IContext<IParams>, { session, userInfo }: IControllerInfos, [baseService, taskService]: [BaseService, TaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        collected: boolean;
        itemId: string;
        name: string;
        price: string;
        url: string;
        image: string;
        desc: string;
    }[], true>>;
}
