"use strict";
/** @format */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var db_1 = require("../db");
var sdk_1 = require("../sdk");
var constants_1 = require("../constants");
var xlsx = require("node-xlsx");
var services_1 = require("../decorator/services");
var service_1 = require("../service");
var decorator_1 = require("../decorator");
/** @format */
var StatController = /** @class */ (function () {
    function StatController() {
    }
    /**
     *  增加埋点记录
     */
    StatController.prototype.addStat = function (context, _a, _b) {
        var userInfo = _a.userInfo;
        var statService = _b[0];
        return __awaiter(this, void 0, void 0, function () {
            var type;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        type = context.data.type;
                        return [4 /*yield*/, statService.addStat(type, userInfo)];
                    case 1:
                        _c.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(true)];
                }
            });
        });
    };
    /**
     *  统计数据
     */
    StatController.prototype.getStats = function (context) {
        var _a, _b, _c, _d;
        return __awaiter(this, void 0, void 0, function () {
            var _e, activityId, startDay, endDay, userDao, accessDao, oneDay, xlsxData, day, PV, UV, newUV, vipPV, vipUV, noVipPV, noVipUV, newVipUV, newFollowUV, getTaskCompleteUV, keyValueMapper, tommorrow, buffer, result, e_1;
            var _this = this;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        _e = context.data, activityId = _e.activityId, startDay = _e.startDay, endDay = _e.endDay;
                        userDao = new sdk_1.BaseDao(context, db_1.USER_DB_NAME);
                        accessDao = new sdk_1.BaseDao(context, db_1.ACCESS_DB_NAME);
                        oneDay = 24 * 3600 * 1000;
                        xlsxData = [];
                        _f.label = 1;
                    case 1:
                        _f.trys.push([1, 14, , 15]);
                        day = startDay;
                        _f.label = 2;
                    case 2:
                        if (!(new Date(day).getTime() <= new Date(endDay).getTime())) return [3 /*break*/, 12];
                        return [4 /*yield*/, accessDao.count({ activityId: activityId, createDay: day })
                            // 访问UV
                        ];
                    case 3:
                        PV = _f.sent();
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } },
                                { $count: 'uv' }
                            ])];
                    case 4:
                        UV = (_b = (_a = (_f.sent())) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.uv;
                        return [4 /*yield*/, userDao.count({
                                activityId: activityId,
                                createDay: day
                            })
                            // 已入会(老会员)PV
                        ];
                    case 5:
                        newUV = _f.sent();
                        return [4 /*yield*/, accessDao.count({
                                activityId: activityId,
                                createDay: day,
                                //@ts-ignore
                                $or: [{ 'member.flag': true }, { 'member.newMember': true }],
                                'member.bememberDay': {
                                    $not: {
                                        $eq: day
                                    }
                                }
                            })
                            // 已入会(老会员)UV
                        ];
                    case 6:
                        vipPV = _f.sent();
                        return [4 /*yield*/, accessDao.aggregate([
                                {
                                    $match: {
                                        activityId: activityId,
                                        createDay: day,
                                        $or: [{ 'member.flag': true }, { 'member.newMember': true }],
                                        'member.bememberDay': {
                                            $not: {
                                                $eq: day
                                            }
                                        }
                                    }
                                },
                                { $project: { openId: true } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } },
                                { $count: 'uv' }
                            ], { allowDiskUse: true })];
                    case 7:
                        vipUV = (_d = (_c = (_f.sent())) === null || _c === void 0 ? void 0 : _c[0]) === null || _d === void 0 ? void 0 : _d.uv;
                        return [4 /*yield*/, accessDao.count({ activityId: activityId, createDay: day, isVip: false })
                            // 未入会UV
                        ];
                    case 8:
                        noVipPV = _f.sent();
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, isVip: false } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 9:
                        noVipUV = (_f.sent()).length;
                        return [4 /*yield*/, userDao.count({
                                activityId: activityId,
                                'member.newMember': true,
                                'member.bememberDay': day
                            })];
                    case 10:
                        newVipUV = _f.sent();
                        return [4 /*yield*/, userDao.count({
                                activityId: activityId,
                                'follow.newFollow': true,
                                'follow.followDay': day
                            })
                            // 根据任务类型获取完成任务的人数
                            //  example: await getTaskCompleteUV('collectGoods', day)
                        ];
                    case 11:
                        newFollowUV = _f.sent();
                        getTaskCompleteUV = function (task, day) { return __awaiter(_this, void 0, void 0, function () {
                            var _a;
                            return __generator(this, function (_b) {
                                switch (_b.label) {
                                    case 0: return [4 /*yield*/, userDao.count((_a = {
                                                activityId: activityId
                                            },
                                            _a["taskInfo." + day + "." + task] = {
                                                $exists: true
                                            },
                                            _a))];
                                    case 1: return [2 /*return*/, _b.sent()];
                                }
                            });
                        }); };
                        keyValueMapper = {
                            时间: day,
                            访问PV: PV,
                            访问UV: UV,
                            新增UV: newUV,
                            已入会PV: vipPV,
                            已入会UV: vipUV,
                            未入会PV: noVipPV,
                            未入会UV: noVipUV,
                            新入会UV: newVipUV,
                            新增关注UV: newFollowUV
                            //收藏商品UV: await getTaskCompleteUV('collectGoods', day)
                        };
                        console.log(keyValueMapper, 'xlsxData');
                        if (day === startDay) {
                            xlsxData.push(Object.keys(keyValueMapper));
                        }
                        // @ts-ignore
                        xlsxData.push(Object.values(keyValueMapper));
                        tommorrow = new Date(day).getTime() + oneDay;
                        day = sdk_1.dateFormatter(sdk_1.transformBeijingDate(tommorrow), 'yyyy/MM/dd');
                        return [3 /*break*/, 2];
                    case 12:
                        buffer = xlsx.build([
                            {
                                name: "\u6570\u636E\u7EDF\u8BA1" + startDay.replace(/\//g, '-') + "-" + endDay.replace(/\//g, '-'),
                                data: xlsxData
                            }
                        ]);
                        return [4 /*yield*/, context.cloud.file.uploadFile({
                                fileContent: buffer,
                                fileName: "\u6570\u636E\u7EDF\u8BA1" + startDay.replace(/\//g, '-') + "-" + endDay.replace(/\//g, '-') + ".xlsx"
                            })];
                    case 13:
                        result = _f.sent();
                        if (result.url) {
                            result.url = result.url.replace('http', 'https').replace('-internal', '');
                        }
                        return [2 /*return*/, sdk_1.resultsModel.success(result)];
                    case 14:
                        e_1 = _f.sent();
                        console.log('上传文件出错', e_1);
                        // 打印日志
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, "\u4E0A\u4F20\u6587\u4EF6\u9519\u8BEF")];
                    case 15: return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        decorator_1.registeInfos(['userInfo']),
        services_1.services([service_1.StatService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], StatController.prototype, "addStat", null);
    return StatController;
}());
exports.default = StatController;
//# sourceMappingURL=stat.controller.js.map