/** @format */
import { StatService } from '../service';
export interface IGetStatsParams {
    activityId: string;
    startDay: string;
    endDay: string;
}
export interface IAddStatsParams {
    activityId: string;
    type: number;
}
/** @format */
export default class StatController {
    /**
     *  增加埋点记录
     */
    addStat(context: IContext<IAddStatsParams>, { userInfo }: IControllerInfos, [statService]: [StatService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<boolean, true>>;
    /**
     *  统计数据
     */
    getStats(context: IContext<IGetStatsParams>): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<string | boolean | object | string[] | number[] | object[], false> | import("taobao-mini-sdk/lib/utils/resultmodel").Result<any, true>>;
}
