"use strict";
/** @format */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./../constants");
var check_1 = require("../decorator/check");
var services_1 = require("../decorator/services");
var sdk_1 = require("../sdk");
var utils_1 = require("../utils");
var service_1 = require("../service");
var registeInfos_1 = require("../decorator/registeInfos");
var constants_2 = require("../constants");
var Share = /** @class */ (function () {
    function Share() {
    }
    /**
     *  获取邀请信息
     */
    Share.prototype.getShareInfo = function (context, _a) {
        var userInfo = _a.userInfo;
        return __awaiter(this, void 0, void 0, function () {
            var invites;
            return __generator(this, function (_b) {
                invites = userInfo.remainTimes.invites;
                return [2 /*return*/, sdk_1.resultsModel.success({
                        rewards: invites
                    })];
            });
        });
    };
    /**
     *  完成分享
     */
    Share.prototype.doHelp = function (context, _a, _b) {
        var userInfo = _a.userInfo, vipInfo = _a.vipInfo, activityInfo = _a.activityInfo;
        var userService = _b[0], taskService = _b[1], statService = _b[2];
        return __awaiter(this, void 0, void 0, function () {
            var _c, inviteId, activityId, openId, inviteUserInfo, userInviteSuccessCount, tasks, value, isNewVip, isValidShare, today, inviteUserId;
            var _d;
            return __generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        _c = context.data, inviteId = _c.inviteId, activityId = _c.activityId;
                        openId = context.openId;
                        if (openId === inviteId)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_NO_INVITE_SELF)];
                        return [4 /*yield*/, userService.getUserInfoByOpenId(inviteId)
                            // inviteId的用户信息查询不到, 则inviteId无效
                        ];
                    case 1:
                        inviteUserInfo = _e.sent();
                        // inviteId的用户信息查询不到, 则inviteId无效
                        if (!inviteUserInfo)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_INVALID_INVITE_ID)
                                // 邀请成功有该用户信息
                            ];
                        return [4 /*yield*/, statService.getStatCountByquery({
                                activityId: activityId,
                                openId: openId,
                                type: constants_2.STAT_TYPE.INITE_SUCCESS
                            })];
                    case 2:
                        userInviteSuccessCount = _e.sent();
                        if (userInviteSuccessCount)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_AREADY_INVITE_SUCCESS)
                                // 获取活动基本信息
                            ];
                        tasks = activityInfo.tasks;
                        value = tasks.invites.value;
                        isNewVip = utils_1.checkNewVip(userInfo, vipInfo);
                        if (!(isNewVip && !userInfo.member.newMember)) return [3 /*break*/, 4];
                        return [4 /*yield*/, userService.updateUser(userInfo._id, {
                                $set: {
                                    member: utils_1.setNewVipUserData(userInfo.member)
                                }
                            })];
                    case 3:
                        _e.sent();
                        _e.label = 4;
                    case 4:
                        isValidShare = [isNewVip].every(function (v) { return !!v; });
                        today = utils_1.getToday();
                        if (!isValidShare)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.ERROR_INVITE)
                                // 成功邀请
                            ];
                        inviteUserId = inviteUserInfo._id;
                        // 增加邀请人的待领取次数和邀请记录
                        return [4 /*yield*/, userService.updateUser(inviteUserId, {
                                $inc: {
                                    'remainTimes.invites': value
                                },
                                $push: (_d = {},
                                    _d["taskInfo." + today + ".invites"] = { openId: openId, createTime: Date.now() },
                                    _d)
                            })];
                    case 5:
                        // 增加邀请人的待领取次数和邀请记录
                        _e.sent();
                        return [4 /*yield*/, statService.addStat(constants_2.STAT_TYPE.INITE_SUCCESS, userInfo)];
                    case 6:
                        _e.sent();
                        return [2 /*return*/, sdk_1.resultsModel.success(true)];
                }
            });
        });
    };
    __decorate([
        check_1.paramsCheck(['activityId']),
        check_1.userCheck({ intercept: true }),
        registeInfos_1.registeInfos(['userInfo', 'activityInfo']),
        services_1.services([service_1.UserService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object]),
        __metadata("design:returntype", Promise)
    ], Share.prototype, "getShareInfo", null);
    __decorate([
        check_1.paramsCheck(['activityId', 'inviteId']),
        check_1.activityTimeCheck,
        check_1.userCheck({ intercept: true }),
        registeInfos_1.registeInfos(['userInfo', 'vipInfo', 'activityInfo']),
        services_1.services([service_1.UserService, service_1.TaskService, service_1.StatService, service_1.AccessService]),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, Object, Array]),
        __metadata("design:returntype", Promise)
    ], Share.prototype, "doHelp", null);
    return Share;
}());
exports.default = Share;
//# sourceMappingURL=share.controller.js.map