"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSurpriseVideo = exports.getEntryStatus = exports.getGamePrize = exports.doLike = exports.getGameInfo = void 0;
var decorator_1 = require("../decorator");
var sdk_1 = require("../sdk");
var constants_1 = require("../constants");
var service_1 = require("../service");
var utils_1 = require("../utils");
var resultsModel = new sdk_1.ResultsModel();
exports.getGameInfo = decorator_1.decorators([
    decorator_1.paramsCheck(['activityId']),
    decorator_1.userCheck({ intercept: true }),
    decorator_1.vipCheck({ intercept: false })
], [service_1.UserService, service_1.AccessService, service_1.RecordService, service_1.AwardsService])(function (context, _a, _b) {
    var userInfo = _a.userInfo, vipInfo = _a.vipInfo;
    var userService = _b[0], accessService = _b[1], recordService = _b[2], awardsService = _b[3];
    return __awaiter(void 0, void 0, void 0, function () {
        var openId, activityId, remainLikes, doLikeCount, orderGoods, _id, hasShowedModal, game2unLockSurpriseClicked, game2NeedBuyTotal, game2StartTime, allNeedLikeTotal, queryTime, done, orderResult, targetOrders, i, order, hasUserGame2Buy, game2unLock, accessTimes, allLikedTotal, isShowModal, myPrizesRecord, has1Prize, has2Prize, has3Prize, has4Prize, has5Prize, prizesDataTypeReceived, game2BuyedTotal, now, today, mockData, likedToday, allLikedTotalString;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    openId = context.openId, activityId = context.data.activityId;
                    remainLikes = userInfo.remainLikes, doLikeCount = userInfo.doLikeCount, orderGoods = userInfo.orderGoods, _id = userInfo._id, hasShowedModal = userInfo.hasShowedModal, game2unLockSurpriseClicked = userInfo.game2unLockSurpriseClicked;
                    game2NeedBuyTotal = constants_1.GAME_INFO_CONFIG.game2NeedBuyTotal, game2StartTime = constants_1.GAME_INFO_CONFIG.game2StartTime, allNeedLikeTotal = constants_1.GAME_INFO_CONFIG.allNeedLikeTotal;
                    queryTime = orderGoods.queryTime, done = orderGoods.done;
                    if (!!done) return [3 /*break*/, 7];
                    return [4 /*yield*/, utils_1.getUserOrderlist(context, queryTime || Date.now())];
                case 1:
                    orderResult = _c.sent();
                    if (!orderResult.some(function (v) { return constants_1.TASK_GOODS_ID.includes(v.itemId); })) return [3 /*break*/, 5];
                    orderGoods.remainTimes = constants_1.TASK_REWARDS.orderGoods;
                    orderGoods.done = true;
                    orderGoods.queryTime = Date.now();
                    targetOrders = orderResult.filter(function (v) {
                        return constants_1.TASK_GOODS_ID.includes(v.itemId);
                    });
                    i = 0;
                    _c.label = 2;
                case 2:
                    if (!(i < targetOrders.length)) return [3 /*break*/, 5];
                    order = targetOrders[i];
                    return [4 /*yield*/, recordService.addRecord(constants_1.RECORD_TYPE.BUY_ORDER.type, __assign({}, order))];
                case 3:
                    _c.sent();
                    _c.label = 4;
                case 4:
                    i++;
                    return [3 /*break*/, 2];
                case 5: return [4 /*yield*/, userService.updateUser(_id, {
                        orderGoods: orderGoods
                    })];
                case 6:
                    _c.sent();
                    _c.label = 7;
                case 7:
                    hasUserGame2Buy = !!orderGoods.done;
                    game2unLock = new Date(game2StartTime).getTime() <= Date.now();
                    return [4 /*yield*/, accessService.getAccessCount()];
                case 8:
                    accessTimes = _c.sent();
                    return [4 /*yield*/, recordService.getLikeTotal()];
                case 9:
                    allLikedTotal = _c.sent();
                    isShowModal = hasShowedModal ? false : accessTimes <= 1;
                    return [4 /*yield*/, userService.updateUser(_id, {
                            hasShowedModal: true
                        })];
                case 10:
                    _c.sent();
                    return [4 /*yield*/, recordService.getGamePrizeRecordDetail()];
                case 11:
                    myPrizesRecord = _c.sent();
                    console.log(myPrizesRecord, 'myPrizes');
                    has1Prize = myPrizesRecord.some(function (v) { return v.prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_1; });
                    has2Prize = myPrizesRecord.some(function (v) { return v.prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_2; });
                    has3Prize = myPrizesRecord.some(function (v) { return v.prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_3; });
                    has4Prize = myPrizesRecord.some(function (v) { return v.prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_2; });
                    has5Prize = myPrizesRecord.some(function (v) { return v.prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_DONE; });
                    prizesDataTypeReceived = [];
                    has1Prize && prizesDataTypeReceived.push(constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_1);
                    has2Prize && prizesDataTypeReceived.push(constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_2);
                    has3Prize && prizesDataTypeReceived.push(constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_3);
                    has4Prize && prizesDataTypeReceived.push(constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_2);
                    has5Prize && prizesDataTypeReceived.push(constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_DONE);
                    return [4 /*yield*/, userService.getBuyedCount()];
                case 12:
                    game2BuyedTotal = _c.sent();
                    now = Date.now();
                    today = utils_1.getToday();
                    if (!constants_1.MOCK_LIKE_DATA[today]) return [3 /*break*/, 14];
                    mockData = constants_1.MOCK_LIKE_DATA[today];
                    if (!(allLikedTotal < mockData.count)) return [3 /*break*/, 14];
                    return [4 /*yield*/, recordService.getLikeByDay(today)];
                case 13:
                    likedToday = _c.sent();
                    allLikedTotal = mockData.count + likedToday;
                    _c.label = 14;
                case 14:
                    allLikedTotal = 12600000;
                    allLikedTotalString = allLikedTotal;
                    if (allLikedTotal >= 10000 && allLikedTotal <= 12500000) {
                        allLikedTotalString = (allLikedTotal / 10000).toFixed(1) + "\u4E07";
                        console.log(allLikedTotalString);
                    }
                    console.log(allLikedTotal, allNeedLikeTotal);
                    return [2 /*return*/, resultsModel.success({
                            isShowModal: isShowModal,
                            remainLikes: remainLikes,
                            myLikedTotal: 100,
                            // myLikedTotal: doLikeCount,
                            // allLikedTotal: 126000,
                            allLikedTotal: allLikedTotalString,
                            likePercent: (allLikedTotal / allNeedLikeTotal).toFixed(2),
                            // likePercent: '100.00',
                            allNeedLikeTotal: "1260\u4E07",
                            game2NeedBuyTotal: game2NeedBuyTotal,
                            game2BuyedTotal: 1000,
                            // game2BuyedTotal,
                            game2unLock: game2unLock,
                            game2unLockSurpriseClicked: !!game2unLockSurpriseClicked,
                            hasUserGame2Buy: hasUserGame2Buy,
                            prizesDataTypeReceived: prizesDataTypeReceived,
                            taskGoodsUrl: constants_1.TASK_GOODS_LINK
                        })];
            }
        });
    });
});
exports.doLike = decorator_1.decorators([decorator_1.paramsCheck(['activityId']), decorator_1.actvityTimeCheck, decorator_1.vipCheck({ intercept: true }), decorator_1.userCheck({ intercept: true })], [service_1.UserService, service_1.RecordService])(function (context, _a, _b) {
    var userInfo = _a.userInfo;
    var userService = _b[0], recordService = _b[1];
    return __awaiter(void 0, void 0, void 0, function () {
        var remainLikes, doLikeCount, _id, error_1;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    remainLikes = userInfo.remainLikes, doLikeCount = userInfo.doLikeCount, _id = userInfo._id;
                    if (remainLikes <= 0)
                        return [2 /*return*/, resultsModel.error(constants_1.CODE_TYPES.ERROR_NO_LIKE_COUNT)];
                    remainLikes -= 1;
                    doLikeCount += 1;
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, 4, , 5]);
                    return [4 /*yield*/, userService.updateUser(_id, {
                            remainLikes: remainLikes,
                            doLikeCount: doLikeCount
                        })];
                case 2:
                    _c.sent();
                    return [4 /*yield*/, recordService.addDoLikeRecord()];
                case 3:
                    _c.sent();
                    return [2 /*return*/, resultsModel.success(true)];
                case 4:
                    error_1 = _c.sent();
                    return [2 /*return*/, resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR)];
                case 5: return [2 /*return*/];
            }
        });
    });
});
exports.getGamePrize = decorator_1.decorators([decorator_1.paramsCheck(['activityId', 'prizeDataType']), decorator_1.vipCheck({ intercept: true }), decorator_1.userCheck({ intercept: true })], [service_1.AwardsService, service_1.UserService, service_1.RecordService])(function (context, _a, _b) {
    var userInfo = _a.userInfo;
    var awardsService = _b[0], userService = _b[1], recordService = _b[2];
    return __awaiter(void 0, void 0, void 0, function () {
        var _c, prizeDataType, activityId, openId, myPrize, orderGoods, queryTime, done, orderResult, targetOrders, i, order, fileId, videoResult, videoResult, prize, stockResult, type, _id, ename, name, image, link, record, result, videoUrl, videoResult;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    _c = context.data, prizeDataType = _c.prizeDataType, activityId = _c.activityId, openId = context.openId;
                    return [4 /*yield*/, awardsService.getMyPrizeByPrizeDataType(prizeDataType)];
                case 1:
                    myPrize = _d.sent();
                    if (myPrize)
                        return [2 /*return*/, resultsModel.error(constants_1.CODE_TYPES.ERROR_RECEIVE_PRIZE)];
                    orderGoods = userInfo.orderGoods;
                    queryTime = orderGoods.queryTime, done = orderGoods.done;
                    if (!!done) return [3 /*break*/, 6];
                    return [4 /*yield*/, utils_1.getUserOrderlist(context, queryTime || Date.now())];
                case 2:
                    orderResult = _d.sent();
                    if (!orderResult.some(function (v) { return constants_1.TASK_GOODS_ID.includes(v.itemId); })) return [3 /*break*/, 6];
                    orderGoods.remainTimes = constants_1.TASK_REWARDS.orderGoods;
                    orderGoods.done = true;
                    orderGoods.queryTime = Date.now();
                    targetOrders = orderResult.filter(function (v) {
                        return constants_1.TASK_GOODS_ID.includes(v.itemId);
                    });
                    i = 0;
                    _d.label = 3;
                case 3:
                    if (!(i < targetOrders.length)) return [3 /*break*/, 6];
                    order = targetOrders[i];
                    return [4 /*yield*/, recordService.addRecord(constants_1.RECORD_TYPE.BUY_ORDER.type, __assign({}, order))];
                case 4:
                    _d.sent();
                    _d.label = 5;
                case 5:
                    i++;
                    return [3 /*break*/, 3];
                case 6:
                    fileId = '';
                    // if (prizeDataType === 1) {
                    //   fileId = 'cloud://D6E2B4EC65A0F5BDBF11DBFAB70F5FA1//proccess2.mov';
                    // }
                    if (prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_2) {
                        fileId = 'cloud://0D5CEE8D0E5FC4DCB24BE7ED842E6156//proccess2.mov';
                    }
                    if (prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.DO_LIKE_3) {
                        fileId = 'cloud://3637723FA51F6458FC4889C3EF5A2DB1//process3.mov';
                    }
                    if (prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_2) {
                        fileId = 'cloud://F45A0E181799E0DF032C34ADF999C2C7//buylimit.mov';
                    }
                    if (!(prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_DONE)) return [3 /*break*/, 9];
                    fileId = 'cloud://65B8CD97FE1802355CCFE2721F996B09//game2_done.mov';
                    return [4 /*yield*/, context.cloud.file.getTempFileURL({ fileId: fileId })];
                case 7:
                    videoResult = _d.sent();
                    return [4 /*yield*/, recordService.addRecord(constants_1.RECORD_TYPE.GAME_PRIZE, {
                            prizeDataType: prizeDataType
                        })];
                case 8:
                    _d.sent();
                    return [2 /*return*/, resultsModel.success({
                            videoUrl: videoResult && videoResult.length && videoResult[0].url
                        })];
                case 9:
                    if (!(prizeDataType === constants_1.DO_LIKE_PRIZE_DATA_TYPE.GAME_2 && !orderGoods.done)) return [3 /*break*/, 12];
                    return [4 /*yield*/, context.cloud.file.getTempFileURL({ fileId: fileId })];
                case 10:
                    videoResult = _d.sent();
                    return [4 /*yield*/, recordService.addRecord(constants_1.RECORD_TYPE.GAME_PRIZE, {
                            prizeDataType: prizeDataType
                        })];
                case 11:
                    _d.sent();
                    return [2 /*return*/, resultsModel.success({
                            videoUrl: videoResult && videoResult.length && videoResult[0].url
                        })];
                case 12: return [4 /*yield*/, awardsService.getGamePrize(prizeDataType)];
                case 13:
                    prize = _d.sent();
                    return [4 /*yield*/, awardsService.reduceStock(prize._id)];
                case 14:
                    stockResult = _d.sent();
                    if (!(stockResult !== true)) return [3 /*break*/, 15];
                    return [2 /*return*/, resultsModel.error(stockResult)];
                case 15: return [4 /*yield*/, recordService.addRecord(constants_1.RECORD_TYPE.GAME_PRIZE, {
                        prizeDataType: prizeDataType
                    })];
                case 16:
                    _d.sent();
                    _d.label = 17;
                case 17:
                    type = prize.type, _id = prize._id, ename = prize.ename, name = prize.name, image = prize.image, link = prize.link;
                    record = {
                        openId: openId,
                        prizeId: _id,
                        activityId: activityId,
                        drawStatus: constants_1.DRAW_STATUS.WAITAWARD,
                        prizeDataType: prizeDataType,
                        remark: '',
                        type: type,
                        ename: ename,
                        name: name,
                        image: image,
                        link: link,
                        userNick: userInfo.userNick,
                        createDay: utils_1.getToday()
                    };
                    return [4 /*yield*/, awardsService.addAward(record)];
                case 18:
                    result = _d.sent();
                    return [4 /*yield*/, userService.updateUser(userInfo._id, {
                            orderGoods: orderGoods
                        })];
                case 19:
                    _d.sent();
                    videoUrl = '';
                    if (!fileId) return [3 /*break*/, 21];
                    return [4 /*yield*/, context.cloud.file.getTempFileURL({ fileId: fileId })];
                case 20:
                    videoResult = _d.sent();
                    videoUrl = videoResult && videoResult.length && videoResult[0].url;
                    _d.label = 21;
                case 21: return [2 /*return*/, resultsModel.success({
                        _id: result,
                        type: type,
                        name: name,
                        image: image,
                        videoUrl: videoUrl
                    })];
            }
        });
    });
});
exports.getEntryStatus = decorator_1.decorators([])(function () { return __awaiter(void 0, void 0, void 0, function () {
    var openTime;
    return __generator(this, function (_a) {
        openTime = new Date(constants_1.ACTIVITY_ENTRY_TIME).getTime();
        return [2 /*return*/, resultsModel.success({
                isOpen: Date.now() >= openTime
            })];
    });
}); });
exports.getSurpriseVideo = decorator_1.decorators([])(function (context) { return __awaiter(void 0, void 0, void 0, function () {
    var videoResult;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, context.cloud.file.getTempFileURL({ fileId: 'cloud://65B8CD97FE1802355CCFE2721F996B09//game2_done.mov' })];
            case 1:
                videoResult = _a.sent();
                return [2 /*return*/, resultsModel.success({
                        videoUrl: videoResult && videoResult.length && videoResult[0].url
                    })];
        }
    });
}); });
//# sourceMappingURL=game.controller.js.map