/** @format */
import { AwardsService } from '../service';
import { CodeType } from 'taobao-mini-sdk/lib/utils/codetypes';
export interface IPrizeListParams {
    activityId: string;
}
export interface IReceiveOjectParams {
    activityId: string;
    id: string;
    name: string;
    phone: string;
    province: string;
    city: string;
    area: string;
    addressDetail: string;
    streetName: string;
}
export interface IReceiveEnameParams {
    activityId: string;
    id: string;
}
export default class AwardsController {
    /**
     *  我的奖品列表
     */
    getMyPrizeList(context: IContext<IPrizeListParams>, {}: {}, [awardSer]: [AwardsService]): Promise<IResult<{
        list: IAwards[];
    }>>;
    /**
     *  领取实物
     */
    receiveObjectPrize(context: IContext<IReceiveOjectParams>, {}: {}, [awardSer]: [AwardsService]): Promise<IResult<boolean>>;
    /**
     *  权益重新领取
     */
    receiveEnamePrize(context: IContext<IReceiveEnameParams>, {}: {}, [awardSer]: [AwardsService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<string | boolean | object | string[] | number[] | object[], false> | import("taobao-mini-sdk/lib/utils/resultmodel").Result<CodeType | IAwards, true>>;
    /**
     *  概率抽奖
     */
    drawLotteryPrize(context: IContext<IParams>, { userInfo }: IControllerInfos, [awardSer]: [AwardsService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result<{
        id: string | CodeType;
        type: number;
        name: string;
        image: string;
    }, true>>;
}
