/** @format */
import { getToday } from '../getToday'
import { isNewVip, setNewVipUserData } from '../userUpdate'

export default async function updateVip(
  context: IContext<IParams>,
  { vipInfo, userInfo, activityInfo }: IControllerInfos
): Promise<IPreUpdateQuery> {
  let { member } = userInfo

  const memberReWards = activityInfo?.tasks?.member?.reward || 0

  return isNewVip(userInfo, vipInfo)
    ? {
        $set: {
          member: setNewVipUserData(member)
        },
        $inc: {
          'remainTimes.member': +memberReWards
        },
        $push: {
          [`taskInfo.${getToday()}.member`]: { creatTime: Date.now() }
        }
      }
    : {}
}
