/** @format */

import { getToday } from '../getToday'
import { getTodayCompleteGrowTask, updateTaskInfo } from '../task'

export default async function updateSignTask(
  context: IContext<IParams>,
  { activityInfo, task }: IControllerInfos
): Promise<IPreUpdateQuery | undefined> {
  if (!activityInfo?.tasks?.sign) return
  // 获取签到奖励
  const { reward } = activityInfo?.tasks?.sign || {}

  const { todayCompleteTimes } = getTodayCompleteGrowTask('sign', task)

  if (todayCompleteTimes === 0) {
    const result = await updateTaskInfo(context, task._id, 'sign', { createTime: Date.now() })
    return result === 1
      ? {
          $inc: {
            'remainTimes.sign': +reward || 0
          }
        }
      : {}
  }
  return {}
}
