/** @format */

import { resultsModel } from '../../sdk'
import { recordErrorLog } from './logger'
import { CODE_TYPES } from '../../errorCode'
import { cloundAlarm } from '../../utils/common/dingTalk'
/** @format */

export async function doHandler(target: Object, method: IFunction, args: any[]) {
  let ret: IResult<any>
  try {
    ret = await method.apply(target, args)
  } catch (error) {
    console.log('error', error)
    const errMessage = error instanceof Error ? error.toString() : JSON.stringify(error)
    recordErrorLog(args[0], args[1], errMessage, error.stack)
    // 云告警
    cloundAlarm(args[0], errMessage)

    ret = resultsModel.error(CODE_TYPES.SYSTEM_ERROR)
  }
  return ret
}
