/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { dbCount } from '../mongodb'
import { STAT_DB_NAME } from '../../../db'
import { STAT_TYPE } from '../../../constants'

/**
 *   检查邀请记录
 *   doHelp接口
 *
 * @export
 * @param {IContext<{ activityId: string; inviteId: string }>} context
 * @return {*}
 */
export default async function checkHelpRecord(
  context: IContext<{ activityId: string; inviteId: string; key: string }>,
  { userInfo }: IControllerInfos
) {
  if (context.data.key === 'invite') {
    const { inviteId } = userInfo
    // 邀请成功有该用户信息
    if (inviteId) return resultsModel.error(CODE_TYPES.ERROR_AREADY_INVITE_SUCCESS)

    return { inviteId }
  }
}
