/** @format */
interface IContext<T> {
  appkey: string
  sourceAppKey: string
  userNick?: string
  mixNick: string
  miniappId: string
  sourceMiniAppId: string
  accessToken: string
  openId: string
  env: string
  consumeId: any
  traceId: string
  fcName: string
  handler: string
  appOwnerOpenId: string
  fcInvokeId: string
  cloud: any
  data: T
}

interface IParams {
  [params: string]: any
}

interface IControllerInfos {
  userInfo: IUserInfo
  vipInfo?: IVipInfo
  activityInfo: IActivityInfo
  session?: string
  credits?: number
  task?: ITask
  taobaoOrderList?: ITaoBaoOrders[]
}

interface ICheckControllerInfos extends IControllerInfos {
  noCheckUser?: boolean
  noCheckActivity?: boolean
  noCatch?: boolean
  registed?: boolean
}

// preCeck返回的数据
interface IPreCheckData {
  inviteUserInfo?: IUserInfo // checkValidInviteId
  awardInfo?: IAwards // checkValidPrize
  joinInfo?: IJoinRecord
}

interface IVipInfo {
  isVip: boolean
  url?: string
}

interface ITask {
  _id?: string
  openId?: string
  activityId?: string
  taskInfo?: any
  createDay?: string
  createTime?: number
}

type IFunction = (...args: any[]) => any

type ValueOf<T> = T extends any[] ? T[number] : T[keyof T]
