/** @format */

import { services, checkParams, registeInfos } from '../decorator/common'
import { resultsModel } from '../sdk'
import { CommonUserService } from '../service/common'

interface IRankList {
  userNick: string
  avatar: string
  score: any
  rank: number
}

export interface IRankResult {
  rank: number
  userNick: string
  avatar: string
  score: number
  list: IRankList[]
}
export default class User {
  /**
   *  获取会员信息
   */
   @checkParams(['activityId', 'isVip'])
   @services([CommonUserService])
   async getVipInfo(
     context: IContext<IParams>,
     { activityInfo }: IControllerInfos,
     [userService]: [CommonUserService]
   ): Promise<IResult<IVipInfo>> {
     // 拼接回调参数
     const result = await userService.getShopVip(context, activityInfo)
 
     return resultsModel.success(result)
   }
  
   /**
   *  获取排行榜
   */
  @checkParams(['activityId', 'rankKey?', 'timeKey?', 'limit?'])
  @services([CommonUserService])
  async getRankList(context: IContext<IParams>, { userInfo }: IControllerInfos, [userService]: [CommonUserService]) {
    const { rankKey = 'totalScore', timeKey = 'updateScoreTime', limit = 200 } = context.data

    const rankInfo = await userService.getMyRankInfo(rankKey, timeKey, userInfo)

    const list = await userService.getRank(rankKey, timeKey, limit)

    return resultsModel.success({
      ...rankInfo,
      ...list
    })
  }
}
